#include <iostream>
#include <vector>
#include <climits>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    if (!(cin >> n)) return 0;
    vector<long long> a(n);
    long long total = 0;
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
        total += a[i];
    }
    long long min_area = LLONG_MAX;
    long long max_area = 0;

    int limit = 1 << n;
    for (int mask = 1; mask < limit - 1; ++mask) {
        long long sumA = 0;
        for (int i = 0; i < n; ++i) {
            if (mask & (1 << i)) sumA += a[i];
        }
        long long sumB = total - sumA;
        if (sumA > 0 && sumB > 0) {
            long long area = sumA * sumB;
            if (area < min_area) min_area = area;
            if (area > max_area) max_area = area;
        }
    }
    if (min_area == LLONG_MAX) min_area = 0;
    cout << min_area << " " << max_area << "\n";
    return 0;
}
