#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
#include <iomanip>

using namespace std;

int main() {
    double x[4], y[4];
    for (int i = 0; i < 4; ++i) {
        cin >> x[i] >> y[i];
    }

    vector<double> dists;
    for (int i = 0; i < 4; ++i) {
        for (int j = i + 1; j < 4; ++j) {
            double dx = x[i] - x[j];
            double dy = y[i] - y[j];
            dists.push_back(sqrt(dx * dx + dy * dy));
        }
    }

    sort(dists.begin(), dists.end());

    double a = dists[0];
    double b = dists[1];
    if (abs(a - b) < 1e-9) {
        for (int i = 2; i < 4; ++i) {
            if (abs(a - dists[i]) > 1e-9) {
                b = dists[i];
                break;
            }
        }
    }

    double pi = acos(-1.0);
    double area = pi * a * b / 4.0;

    cout << fixed << setprecision(9) << area << endl;

    return 0;
}