#include <iostream>
#include <vector>
#include <cstdint>

using namespace std;

static const int MODM = 999983;
static const int Acoef = 618023;

inline int next_s(int s) {
    long long v = (1LL * s * Acoef + 1) % MODM;
    return (int)v;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, s;
    if (!(cin >> n >> s)) return 0;

    vector<unsigned char> present(MODM, 0);
    vector<int> vals;  vals.reserve(200000);

    int sizeV = 0;

    for (int step = 0; step < n; ++step) {
        s = next_s(s);

        int parity = 0;
        for (int a : vals) {
            if (a > s) continue;
            int b = s - a;
            if (a > b) continue;
            if (present[b]) parity ^= 1;
        }

        if (parity == 0 && !present[s]) {
            present[s] = 1;
            vals.push_back(s);
            ++sizeV;
        }
    }

    cout << sizeV << '\n';
    return 0;
}
