#include <iostream>
#include <vector>
#include <cstdint>
using namespace std;

static const int M = 999983;
static const int W = (M + 63) / 64 + 1; // +1,    

inline bool get_bit(const vector<uint64_t>& a, int idx) {
    return (a[idx >> 6] >> (idx & 63)) & 1ULL;
}
inline void flip_bit(vector<uint64_t>& a, int idx) {
    a[idx >> 6] ^= (1ULL << (idx & 63));
}
inline void set_bit(vector<uint64_t>& a, int idx) {
    a[idx >> 6] |= (1ULL << (idx & 63));
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, s;
    cin >> n >> s;

    vector<uint64_t> A(W, 0), P(W, 0);

    const int MUL = 618023;

    int sizeV = 0;

    for (int step = 0; step < n; ++step) {
        s = (int)(((long long)s * MUL + 1) % M);

        if (!get_bit(A, s) && !get_bit(P, s)) {
            int shift_bits = s & 63;
            int shift_words = s >> 6;

            uint64_t carry = 0;
            for (int w = 0; w + shift_words < W; ++w) {
                uint64_t v = A[w];
                uint64_t lo = (v << shift_bits) | carry;
                uint64_t hi = (shift_bits == 0) ? 0 : (v >> (64 - shift_bits));
                P[w + shift_words] ^= lo;
                carry = hi;
            }

            if (2 * s < M) flip_bit(P, 2 * s);

            set_bit(A, s);
            ++sizeV;
        }
    }

    cout << sizeV << '\n';
    return 0;
}
