#include <iostream>
#include <vector>
#include <utility>

using namespace std;

static const int MOD = 1'000'000'007;

long long modpow(long long a, long long e) {
    long long r = 1;
    while (e) {
        if (e & 1) r = r * a % MOD;
        a = a * a % MOD;
        e >>= 1;
    }
    return r;
}

long long inv(long long x) {
    return modpow(x, MOD - 2);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    if (!(cin >> T)) return 0;

    vector<pair<int, int>> qs(T);
    int maxP = 0;
    for (int i = 0; i < T; ++i) {
        int p, m;
        cin >> p >> m;
        qs[i] = make_pair(p, m);
        if (p > maxP) maxP = p;
    }

    int LIM = 2 * maxP;
    vector<long long> fact(LIM + 1), ifact(LIM + 1);
    fact[0] = 1;
    for (int i = 1; i <= LIM; ++i)
        fact[i] = fact[i - 1] * i % MOD;

    ifact[LIM] = inv(fact[LIM]);
    for (int i = LIM; i > 0; --i)
        ifact[i - 1] = ifact[i] * i % MOD;

    auto C = [&](int n, int k) -> long long {
        if (k < 0 || k > n) return 0;
        return fact[n] * ifact[k] % MOD * ifact[n - k] % MOD;
        };

    for (size_t i = 0; i < qs.size(); ++i) {
        int p = qs[i].first;
        int m = qs[i].second;

        long long fourp = modpow(4, p);
        long long bin = C(2 * p, p);
        long long term1 = fourp * inv(bin) % MOD;
        long long add = (1 + (long long)m * inv(2LL * p + 1) % MOD) % MOD;
        long long ans = term1 * add % MOD;
        cout << ans << '\n';
    }

    return 0;
}
