#include <bits/stdc++.h>

const int MOD = 1e9 + 7;
const int MAX = 2000005;

int fact[MAX], invfact[MAX];

int modPower(int a, int e) {
    int res = 1;
    while (e) {
        if (e & 1) res = 1LL * res * a % MOD;
        a = 1LL * a * a % MOD;
        e >>= 1;
    }
    return res;
}

void beforeCalc() {
    fact[0] = 1;
    for (int i = 1; i < MAX; i++)
        fact[i] = 1LL * fact[i-1] * i % MOD;
    invfact[MAX-1] = modPower(fact[MAX-1], MOD-2);
    for (int i = MAX-2; i >= 0; i--)
        invfact[i] = 1LL * invfact[i+1] * (i+1) % MOD;
}

int bKoeff(int n, int r) {
    if (r < 0 || r > n) return 0;
    return 1LL * fact[n] * invfact[r] % MOD * invfact[n-r] % MOD;
}

int solve(int p, int m) {
    int n = 2*p + m;
    long long ans = 1;
    for (int k = 1; k <= n; k++) {
        long long sum = 0;
        for (int i = 0; i <= std::min(k, p); i++) {
            if (k - i > m) continue;
            long long term = 1LL * bKoeff(p, i) * modPower(2, i) % MOD;
            term = term * bKoeff(m, k - i) % MOD;
            sum = (sum + term) % MOD;
        }
        long long prob = sum * modPower(bKoeff(n, k), MOD-2) % MOD;
        ans = (ans + prob) % MOD;
    }
    return ans;
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
    beforeCalc();
    int t;
    std::cin >> t;
    while (t--) {
        int p, m;
        std::cin >> p >> m;
        std::cout << solve(p, m) << "\n";
    }
    return 0;
}