#include <bits/stdc++.h>
using namespace std;
using int64 = long long;
const int64 MOD = 1'000'000'007LL;

int64 modpow(int64 a, int64 e, int64 mod) {
    int64 r = 1 % mod;
    a %= mod;
    while (e) {
        if (e & 1) r = (__int128)r * a % mod;
        a = (__int128)a * a % mod;
        e >>= 1;
    }
    return r;
}

struct NTT {
    int mod;
    int root;
    NTT() = default;
    NTT(int mod_, int root_): mod(mod_), root(root_) {}

    int add(int a, int b) const { a += b; if (a >= mod) a -= mod; return a; }
    int sub(int a, int b) const { a -= b; if (a < 0) a += mod; return a; }
    int mul(int a, int b) const { return (int)((int64)a * b % mod); }

    void ntt(vector<int>& a, bool invert) const {
        int n = (int)a.size();
        static vector<int> rev;
        if ((int)rev.size() != n) {
            rev.assign(n,0);
            int logn = __builtin_ctz(n);
            for (int i = 0; i < n; ++i)
                rev[i] = (rev[i>>1] >> 1) | ((i & 1) << (logn - 1));
        }
        for (int i = 0; i < n; ++i)
            if (i < rev[i]) swap(a[i], a[rev[i]]);

        for (int len = 1; len < n; len <<= 1) {
            int step = modpow(root, (mod - 1) / (len * 2), mod);
            for (int i = 0; i < n; i += 2 * len) {
                int w = 1;
                for (int j = 0; j < len; ++j) {
                    int u = a[i + j];
                    int v = (int)((int64)a[i + j + len] * w % mod);
                    a[i + j] = u + v < mod ? u + v : u + v - mod;
                    a[i + j + len] = u - v >= 0 ? u - v : u - v + mod;
                    w = (int)((int64)w * step % mod);
                }
            }
        }
        if (invert) {
            reverse(a.begin() + 1, a.end());
            int inv_n = (int)modpow(n, mod - 2, mod);
            for (int &x : a) x = (int)((int64)x * inv_n % mod);
        }
    }

    vector<int> multiply(const vector<int>& A, const vector<int>& B) const {
        if (A.empty() || B.empty()) return {};
        int need = (int)A.size() + (int)B.size() - 1;
        int n = 1;
        while (n < need) n <<= 1;
        vector<int> fa(n), fb(n);
        for (size_t i = 0; i < A.size(); ++i) fa[i] = A[i] % mod;
        for (size_t i = 0; i < B.size(); ++i) fb[i] = B[i] % mod;
        ntt(fa, false);
        ntt(fb, false);
        for (int i = 0; i < n; ++i) fa[i] = (int)((int64)fa[i] * fb[i] % mod);
        ntt(fa, true);
        fa.resize(need);
        return fa;
    }
};

const int MOD1 = 167772161;
const int ROOT1 = 3;
const int MOD2 = 469762049;
const int ROOT2 = 3;
const int MOD3 = 1224736769;
const int ROOT3 = 3;

int64 garner3(int64 r1, int64 r2, int64 r3) {
    const int64 m1 = MOD1;
    const int64 m2 = MOD2;
    const int64 m3 = MOD3;

    int64 inv_m1_mod_m2 = modpow(m1 % m2, m2 - 2, m2);
    int64 t1 = (r2 - r1) % m2;
    if (t1 < 0) t1 += m2;
    t1 = (__int128)t1 * inv_m1_mod_m2 % m2;

    __int128 combined12 = (__int128)r1 + (__int128)t1 * m1;
    int64 combined12_mod_m3 = (int64)(combined12 % m3);
    int64 m1m2_mod_m3 = (int64)((__int128)(m1 % m3) * (m2 % m3) % m3);
    int64 inv_m1m2_mod_m3 = modpow(m1m2_mod_m3, m3 - 2, m3);
    int64 t2 = (r3 - combined12_mod_m3) % m3;
    if (t2 < 0) t2 += m3;
    t2 = (__int128)t2 * inv_m1m2_mod_m3 % m3;

    __int128 full = combined12 + (__int128)t2 * m1 * m2;
    int64 res = (int64)(full % MOD);
    if (res < 0) res += MOD;
    return res;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    if (!(cin >> T)) return 0;
    vector<pair<int,int>> qs(T);
    int maxP = 0, maxM = 0;
    for (int i = 0; i < T; ++i) {
        int p, m;
        cin >> p >> m;
        qs[i] = {p, m};
        maxP = max(maxP, p);
        maxM = max(maxM, m);
    }

    int maxN = 2 * maxP + maxM;
    int maxLen = maxP + maxM;

    vector<int64> fact(maxN + 1), invfact(maxN + 1);
    fact[0] = 1;
    for (int i = 1; i <= maxN; ++i) fact[i] = fact[i-1] * i % MOD;
    invfact[maxN] = modpow(fact[maxN], MOD - 2, MOD);
    for (int i = maxN; i >= 1; --i) invfact[i-1] = invfact[i] * i % MOD;

    NTT n1(MOD1, ROOT1), n2(MOD2, ROOT2), n3(MOD3, ROOT3);

    for (auto &pr : qs) {
        int p = pr.first, m = pr.second;
        int N = 2*p + m;
        int len = p + m + 1;

        vector<int> A1(p+1), A2(p+1), A3(p+1);
        int64 pow2 = 1;
        for (int k = 0; k <= p; ++k) {
            int64 C = fact[p] * invfact[k] % MOD * invfact[p-k] % MOD;
            int64 val = C * pow2 % MOD;
            A1[k] = (int)(val % MOD1);
            A2[k] = (int)(val % MOD2);
            A3[k] = (int)(val % MOD3);
            pow2 = (pow2 * 2) % MOD;
        }

        vector<int> B1(m+1), B2(m+1), B3(m+1);
        for (int j = 0; j <= m; ++j) {
            int64 C = fact[m] * invfact[j] % MOD * invfact[m-j] % MOD;
            B1[j] = (int)(C % MOD1);
            B2[j] = (int)(C % MOD2);
            B3[j] = (int)(C % MOD3);
        }

        vector<int> R1 = n1.multiply(A1, B1);
        vector<int> R2 = n2.multiply(A2, B2);
        vector<int> R3 = n3.multiply(A3, B3);

        vector<int64> S(len);
        for (int t = 0; t < len; ++t) {
            int64 r1 = t < (int)R1.size() ? R1[t] : 0;
            int64 r2 = t < (int)R2.size() ? R2[t] : 0;
            int64 r3 = t < (int)R3.size() ? R3[t] : 0;
            S[t] = garner3(r1, r2, r3);
        }

        int64 invFactN = invfact[N];
        int64 sum = 0;
        for (int t = 0; t <= p + m; ++t) {
            if (t > N) break;
            int64 term = fact[t] % MOD;
            term = term * (S[t] % MOD) % MOD;
            term = term * fact[N - t] % MOD;
            sum += term;
            if (sum >= MOD) sum -= MOD;
        }
        int64 ans = sum * invFactN % MOD;
        cout << ans << '\n';
    }

    return 0;
}
