﻿#define _CRT_SECURE_NO_WARNINGS
#include <stdio.h>
#include <stdlib.h>

#define MOD 999983
#define THRESHOLD 1000  // Переключаемся при большом размере

int main() {
	long long n, s;
	scanf("%lld %lld", &n, &s);

	long long* elements = (long long*)malloc(200000 * sizeof(long long));
	unsigned char* exists = (unsigned char*)calloc((MOD + 7) / 8, 1);
	int len = 0;

	for (int i = 0; i < n; i++) {
		s = (s * 618023 + 1) % MOD;
		int count_p = 0;

		if (len < THRESHOLD) {
			// Маленький размер - полный перебор
			for (int j = 0; j < len; j++) {
				for (int k = j; k < len; k++) {
					if (elements[j] + elements[k] == s) {
						count_p++;
					}
				}
			}
		}
		else {
			// Большой размер - битовый массив
			for (int j = 0; j < len; j++) {
				long long needed = s - elements[j];
				if (needed >= elements[j] && needed < MOD) {
					int byte_idx = needed / 8;
					int bit_idx = needed % 8;
					if (exists[byte_idx] & (1 << bit_idx)) {
						count_p++;
					}
				}
			}
		}

		if (count_p % 2 == 0) {
			elements[len] = s;
			if (len >= THRESHOLD) {
				int byte_idx = s / 8;
				int bit_idx = s % 8;
				exists[byte_idx] |= (1 << bit_idx);
			}
			len++;
		}
	}

	printf("%d", len);
	free(elements);
	free(exists);
	return 0;
}