﻿#define _CRT_SECURE_NO_WARNINGS
#include <stdio.h>
#include <stdlib.h>

#define MOD 999983
#define TABLE_SIZE 200011

typedef struct {
	long long key;
	int count;
} HashEntry;

HashEntry hashTable[TABLE_SIZE];

int hash(long long key) {
	return (int)((key * 2654435761LL) % TABLE_SIZE);  // Улучшенная хэш-функция
}

void insert(long long key) {
	int idx = hash(key);
	while (hashTable[idx].count > 0 && hashTable[idx].key != key) {
		idx = (idx + 1) % TABLE_SIZE;
	}
	if (hashTable[idx].count == 0) {
		hashTable[idx].key = key;
	}
	hashTable[idx].count++;
}

int get_count(long long key) {
	int idx = hash(key);
	while (hashTable[idx].count > 0 && hashTable[idx].key != key) {
		idx = (idx + 1) % TABLE_SIZE;
	}
	return hashTable[idx].count;
}

int main() {
	long long n, s;
	scanf("%lld %lld", &n, &s);

	// Инициализация
	for (int i = 0; i < TABLE_SIZE; i++) {
		hashTable[i].count = 0;
	}

	int len = 0;

	for (int i = 0; i < n; i++) {
		s = (s * 618023 + 1) % MOD;
		int count_p = 0;

		// Подсчёт пар только по хэш-таблице
		for (int j = 0; j < TABLE_SIZE; j++) {
			if (hashTable[j].count > 0) {
				long long a = hashTable[j].key;
				long long b = s - a;
				if (a <= b) {  // Условие a <= b
					if (a == b) {
						// Пара (a, a) - нужен квадрат
						int cnt = hashTable[j].count;
						count_p += cnt * (cnt + 1) / 2;  // C(cnt + 1, 2)
					}
					else {
						count_p += hashTable[j].count * get_count(b);
					}
				}
			}
		}

		if (count_p % 2 == 0) {
			insert(s);
			len++;
		}
	}

	printf("%d", len);
	return 0;
}