#include <bits/stdc++.h>
using namespace std;

const int MOD = 1000000007;
const int MAX_N = 2000000;
const int MAX_P = 1000000;

long long fact[MAX_N + 1];
long long inv_fact[MAX_N + 1];
long long pow4[MAX_P + 1];

long long pow_mod(long long base, long long exp, long long mod) {
    long long result = 1;
    while (exp) {
        if (exp & 1) result = (result * base) % mod;
        base = (base * base) % mod;
        exp >>= 1;
    }
    return result;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i <= MAX_N; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }
    inv_fact[MAX_N] = pow_mod(fact[MAX_N], MOD - 2, MOD);
    for (int i = MAX_N - 1; i >= 0; i--) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    }
    
    pow4[0] = 1;
    for (int i = 1; i <= MAX_P; i++) {
        pow4[i] = pow4[i - 1] * 4 % MOD;
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    precompute();
    int t;
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        long long _num = (2LL * p + m + 1) % MOD;
        _num = _num * pow4[p] % MOD;
        _num = _num * fact[p] % MOD;
        _num = _num * fact[p] % MOD;
        
        long long _den = (2LL * p + 1) % MOD;
        _den = _den * fact[2 * p] % MOD;
        
        long long inv_den = pow_mod(_den, MOD - 2, MOD);
        long long ans = _num * inv_den % MOD;
        cout << ans << '\n';
    }
    return 0;
}
