def can_play(melody):
    positions = {}
    for i in range(52):
        note = "ABCDEFG"[i % 7]
        if note not in positions:
            positions[note] = []
        positions[note].append(i)

    current_positions = set(positions[melody[0]])

    for note in melody[1:]:
        next_positions = set()
        for pos in current_positions:
            for new_pos in positions[note]:
                if abs(new_pos - pos) <= 3:
                    next_positions.add(new_pos)
        current_positions = next_positions
        if not current_positions:
            return False

    return bool(current_positions)


t = int(input())
for _ in range(t):
    s = input().strip()
    print("Yes" if can_play(s) else "No")