import sys


class Fenwick:
    def __init__(self, n):
        self.n = n
        self.tree = [0] * (n + 2)

    def update(self, idx, delta):
        i = idx + 1
        while i <= self.n:
            self.tree[i] += delta
            i += i & -i

    def query(self, idx):
        res = 0
        i = idx + 1
        while i > 0:
            res += self.tree[i]
            i -= i & -i
        return res

    def find_kth(self, k):
        """Найти позицию где сумма равна k"""
        idx = 0
        bit_mask = 1
        while bit_mask < self.n:
            bit_mask <<= 1
        bit_mask >>= 1

        pos = 0
        while bit_mask:
            next_pos = pos + bit_mask
            if next_pos <= self.n and self.tree[next_pos] <= k:
                k -= self.tree[next_pos]
                pos = next_pos
            bit_mask >>= 1
        return pos


def solve():
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return

    n = int(input_data[0])
    a = list(map(int, input_data[1:1 + n]))

    fw = Fenwick(n)
    for i in range(n):
        fw.update(i, 1)

    result = [0] * n

    for i in range(n - 1, -1, -1):
        k = i - a[i]
        pos = fw.find_kth(k)
        result[pos] = i + 1
        fw.update(pos, -1)

    print(' '.join(map(str, result)))


if __name__ == "__main__":
    solve()