import sys


def transform(q, r, s, k, f):
    if f == 0:
        if k == 0:
            return (q, r, s)
        elif k == 1:
            return (-r, -s, -q)
        elif k == 2:
            return (s, q, r)
        elif k == 3:
            return (-q, -r, -s)
        elif k == 4:
            return (r, s, q)
        elif k == 5:
            return (-s, -q, -r)
    else:
        if k == 0:
            return (r, q, s)
        elif k == 1:
            return (-q, -s, -r)
        elif k == 2:
            return (s, r, q)
        elif k == 3:
            return (-r, -q, -s)
        elif k == 4:
            return (q, s, r)
        elif k == 5:
            return (-s, -r, -q)


def main():
    data = sys.stdin.read().splitlines()
    if not data:
        return

    n = int(data[0].strip())
    original_lines = []
    index = 1
    for i in range(2 * n - 1):
        line = data[index].split()
        index += 1
        original_lines.append(list(map(int, line)))

    ops = data[index].strip()

    k, f = 0, 0
    for op in ops:
        if op == 'T':
            f = 1 - f
        elif op == 'R':
            if f == 0:
                k = (k + 5) % 6
            else:
                k = (k + 1) % 6
        elif op == 'L':
            if f == 0:
                k = (k + 1) % 6
            else:
                k = (k + 5) % 6

    if f == 0:
        k_inv = (6 - k) % 6
        f_inv = 0
    else:
        k_inv = k
        f_inv = 1

    output_lines = []
    for i in range(2 * n - 1):
        output_row = []
        s = n - 1 - i
        q_min = -n + 1 + max(0, i - (n - 1))
        count = len(original_lines[i])
        for j in range(count):
            q = q_min + j
            r = -q - s
            q0, r0, s0 = transform(q, r, s, k_inv, f_inv)
            i0 = n - 1 - s0
            if i0 < 0 or i0 >= 2 * n - 1:
                output_row.append(0)
            else:
                q0_min = -n + 1 + max(0, i0 - (n - 1))
                j0 = q0 - q0_min
                if j0 < 0 or j0 >= len(original_lines[i0]):
                    output_row.append(0)
                else:
                    output_row.append(original_lines[i0][j0])
        output_lines.append(output_row)

    for row in output_lines:
        print(" ".join(map(str, row)))


if __name__ == '__main__':
    main()