#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
using namespace std;

struct Point {
    long long x, y;
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n; cin >> n;
    vector<Point> points(n);
    for (int i = 0; i < n; ++i)
        cin >> points[i].x >> points[i].y;

    long double mx_dist = -1.0;
    long long best_a = 0, best_b = 0, best_c1 = 0, best_c2 = 0;

    for (int i = 0; i < n; ++i) {
        for (int j = i + 1; j < n; ++j) {
            long long dx = points[j].x - points[i].x, dy = points[j].y - points[i].y;
    
            long long a1 = dy, b1 = -dx;
            long long den1 = a1 * a1 + b1 * b1;
            if (den1 > 0) {
                long long v_min1 = -1, v_max1 = -1;
                for (int k = 0; k < n; ++k) {
                    long long v = a1 * points[k].x + b1 * points[k].y;
                    if (k == 0)
                        v_min1 = v, v_max1 = v;
                    else {
                        if (v < v_min1) v_min1 = v;
                        if (v > v_max1) v_max1 = v;
                    }
                }
                
                long double num1 = (v_max1 - v_min1) * (v_max1 - v_min1);
                long double cur_dist = num1 / den1;
                if (cur_dist > mx_dist) {
                    mx_dist = cur_dist;
                    best_a = a1, best_b = b1;
                    best_c1 = -v_max1, best_c2 = -v_min1;
                }
            }

            long long a2 = dx, b2 = dy;
            long long den2 = a2 * a2 + b2 * b2;
            if (den2 > 0) {
                long long v_min2 = -1, v_max2 = -1;
                for (int k = 0; k < n; ++k) {
                    long long v = a2 * points[k].x + b2 * points[k].y;
                     if (k == 0)
                        v_min2 = v, v_max2 = v;
                    else {
                        if (v < v_min2) v_min2 = v;
                        if (v > v_max2) v_max2 = v;
                    }
                }
                
                long double num2 = (v_max2 - v_min2) * (v_max2 - v_min2);
                long double cur_dist = num2 / den2;
                if (cur_dist > mx_dist) {
                    mx_dist = cur_dist;
                    best_a = a2, best_b = b2;
                    best_c1 = -v_max2, best_c2 = -v_min2;
                }
            }
        }
    }
    
    cout << best_a << " " << best_b << " " << best_c1 << endl;
    cout << best_a << " " << best_b << " " << best_c2 << endl;
    return 0;
}