#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
#include <limits>

using namespace std;

struct Point {
    long long x, y;
};
Point p0_global;

long long cross_product(Point p0, Point p1, Point p2) {
    return (p1.x - p0.x) * (p2.y - p0.y) - (p1.y - p0.y) * (p2.x - p0.x);
}

long long dist_sq(Point a, Point b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

bool compare_points(Point p1, Point p2) {
    long long cp = cross_product(p0_global, p1, p2);
    if (cp == 0)
        return dist_sq(p0_global, p1) < dist_sq(p0_global, p2);
    return cp > 0;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n; cin >> n;
    vector<Point> points(n);

    int p0_idx = 0;
    for (int i = 0; i < n; ++i) {
        cin >> points[i].x >> points[i].y;
        if (points[i].y < points[p0_idx].y ||
            (points[i].y == points[p0_idx].y && points[i].x < points[p0_idx].x)) {
            p0_idx = i;
        }
    }
    swap(points[0], points[p0_idx]); 
    p0_global = points[0];
    sort(points.begin() + 1, points.end(), compare_points);

    vector<Point> hull = { points[0] };
    for (int i = 1; i < n; ++i) {
        while (hull.size() >= 2 &&
               cross_product(hull[hull.size()-2], hull.back(), points[i]) <= 0) {
            hull.pop_back();
        }
        hull.push_back(points[i]);
    }
    long long max_diam_sq = -1;
    Point p_dia1, p_dia2;
    for (size_t i = 0; i < hull.size(); ++i) {
        for (size_t j = i + 1; j < hull.size(); ++j) {
            long long cur_dist_sq = dist_sq(hull[i], hull[j]);
            if (cur_dist_sq > max_diam_sq) {
                max_diam_sq = cur_dist_sq;
                p_dia1 = hull[i], p_dia2 = hull[j];
            }
        }
    }

    long long final_a = p_dia2.x - p_dia1.x, final_b = p_dia2.y - p_dia1.y;
    long long c_for_p_dia1 = -(final_a * p_dia1.x + final_b * p_dia1.y);
    long long c_for_p_dia2 = -(final_a * p_dia2.x + final_b * p_dia2.y);
    if (c_for_p_dia1 > c_for_p_dia2)
        swap(c_for_p_dia1, c_for_p_dia2);
    cout << final_a << " " << final_b << " " << c_for_p_dia1 << endl;
    cout << final_a << " " << final_b << " " << c_for_p_dia2 << endl;

    return 0;
}