#include <iostream>
#include <vector>
#include <cmath>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<pair<long long, long long>> pts(n);
    for (int i = 0; i < n; ++i)
        cin >> pts[i].first >> pts[i].second;

    long long ba = 0, bb = 0, bc1 = 0, bc2 = 0;
    long double best = -1.0L;

    for (int i = 0; i < n; ++i) {
        long long x1 = pts[i].first, y1 = pts[i].second;
        for (int j = i + 1; j < n; ++j) {
            long long a = pts[j].first - x1;
            long long b = pts[j].second - y1;
            if (a == 0 && b == 0) continue;

            long long t0 = pts[0].first * a + pts[0].second * b;
            long long tmin = t0, tmax = t0;
            for (int k = 1; k < n; ++k) {
                long long t = pts[k].first * a + pts[k].second * b;
                if (t < tmin) tmin = t;
                if (t > tmax) tmax = t;
            }

            long double cur = (long double)(tmax - tmin) * (tmax - tmin)
                / (long double)(a * a + b * b);
            if (cur > best) {
                best = cur;
                ba = a; bb = b;
                bc1 = -tmin; bc2 = -tmax;
            }
        }
    }

    if (ba < 0 || (ba == 0 && bb < 0)) {
        ba = -ba; bb = -bb;
        bc1 = -bc1; bc2 = -bc2;
    }

    cout << ba << " " << bb << " " << bc1 << "\n";
    cout << ba << " " << bb << " " << bc2 << "\n";
    return 0;
}
