from itertools import combinations


def solve():
    n = int(input())
    pairs = list(map(int, input().split()))

    total_sum = sum(pairs) * 2  # общая сумма всех досок

    # Пробуем все возможные разбиения на две группы
    min_area = float('inf')
    max_area = 0

    # Перебираем все подмножества для одной стороны
    for k in range(1, n):
        for comb in combinations(range(n), k):
            sum1 = sum(pairs[i] for i in comb)
            sum2 = total_sum // 2 - sum1  # вторая сторона

            area = sum1 * sum2
            if area > 0:  # площадь должна быть положительной
                min_area = min(min_area, area)
                max_area = max(max_area, area)

    # Если только один вариант
    if min_area == float('inf'):
        min_area = max_area

    print(min_area, max_area)


if __name__ == "__main__":
    solve()