import math


def solve():
    coords = list(map(int, input().split()))
    x1, y1, x2, y2, x3, y3, x4, y4 = coords

    # Вычисляем длины всех сторон
    side1 = math.sqrt((x2 - x1) ** 2 + (y2 - y1) ** 2)
    side2 = math.sqrt((x3 - x2) ** 2 + (y3 - y2) ** 2)
    side3 = math.sqrt((x4 - x3) ** 2 + (y4 - y3) ** 2)
    side4 = math.sqrt((x1 - x4) ** 2 + (y1 - y4) ** 2)

    # Ширина и высота - две разные длины сторон
    width = min(side1, side2)
    height = max(side1, side2)

    # Если первая сторона не минимальная, корректируем
    if side1 != width:
        width, height = height, width

    area = math.pi * width * height / 4
    print(f"{area:.8f}")


if __name__ == "__main__":
    solve()