import sys


def should_use_random(x):
    # Для маленьких чисел всегда collatz
    if x <= 100:
        return False

    # Степени двойки быстро уменьшаются
    if (x & (x - 1)) == 0:
        return False

    # Если число чётное и следующее будет маленьким
    if x % 2 == 0 and x // 2 < 1000:
        return False

    # Числа 3 mod 4 часто ведут к росту
    if x % 4 == 3:
        return True

    # Большие нечётные числа
    if x > 10000 and x % 2 == 1:
        return True

    # Случай для очень больших чисел
    if x > 10 ** 6:
        return (x % 5 == 0)

    return False


def main():
    t = int(sys.stdin.readline())

    for _ in range(t):
        x = int(sys.stdin.readline())

        while True:
            if x == 1:
                break

            if should_use_random(x):
                print("random")
            else:
                print("collatz")
            sys.stdout.flush()

            x = int(sys.stdin.readline())
            if x == 0:
                return


if __name__ == "__main__":
    main()