#include <iostream>

int nextTick(int time, int clock[4], int h, int m, int lim)
{
    if (time + 1 > lim)
    {
        return false;
    }

    int hh = time / m;
    int mm = time - hh * m;

    clock[0] = hh / 10;
    clock[1] = hh % 10;
    clock[2] = mm / 10;
    clock[3] = mm % 10;

    return true;
}

bool isValid(int clock[4])
{
    if (clock[1] == 2 && clock[2] == 3 && clock[3] == 9)
    {
        return true;
    }
    if (clock[0] == 2 && clock[2] == 3 && clock[3] == 9)
    {
        if (clock[1] == 0 || clock[1] == 2 || clock[1] == 3)
        {
            return true;
        }
        return false;
    }
    if (clock[0] == 2 && clock[1] == 3 && clock[3] == 9)
    {
        if (clock[2] == 0 || clock[2] == 3 || clock[2] == 9)
        {
            return true;
        }
        return false;
    }
    if (clock[0] == 2 && clock[1] == 3 && clock[2] == 9)
    {
        return true;
    }
    return false;
}

int main()
{
    int H, M;
    std::cin >> H >> M;
    int answer = 0;
    int time = 0;
    int lim = H * M;
    int clock[4] = {0};

    while (nextTick(time, clock, H, M, lim))
    {
        ++time;
        if (isValid(clock))
        {
            ++answer;
        }
    }
    std::cout << answer;

    return 0;
}
