#include <iostream>
#include <vector>
#include <algorithm>

int mod7(int n)
{
    n = (n + 7) % 7;
    if (n < 4)
    {
        return n;
    }
    return n - 7;
}

bool solve(const std::string &s)
{
    std::vector<int> test;
    test.reserve(s.size());
    for (const auto &c : s)
    {
        test.push_back(c - 'A');
    }

    for (std::size_t i = 1; i < test.size(); ++i)
    {
        if (std::min(
            (test[i - 1] - test[i] + 7) % 7,
            7 - (test[i - 1] - test[i] + 7) % 7) > 3)
        {
            return false;
        }
    }

    int p = 0, mxp = 0, mnp = 0;
    int ll = 1337;
    int rr = 9111;
    for (std::size_t i = 1; i < test.size(); ++i)
    {
        int v = test[i] - test[i - 1];
        int m = mod7(v);
        p += m;

        if (p < mnp)
        {
            mnp = std::min(mnp, p);
            ll = test[i];
        }
        if (p > mxp)
        {
            mxp = std::max(mxp, p);
            rr = test[i];
        }
    }
    if (mxp - mnp > 51)
    {
        return false;
    }
    if (mxp - mnp < 46)
    {
        return true;
    }
    if (0 <= ll && ll <= 2 && 0 <= rr && rr <= 2)
    {
        return true;
    }

    return false;
}

int main()
{
    int n;
    std::string test;
    std::cin >> n;

    while (n--)
    {
        std::cin >> test;
        std::cout << (solve(test) ? "Yes" : "No") << '\n';
    }
    return 0;
}
