#include <iostream>
#include <vector>
#include <climits>
#include <algorithm>
#include <map>
#include <numeric>
#include <math.h>
#include <cmath>
#include <unordered_map>
#include <string>
#include <stack>
#include <queue>
#include <iomanip>
#include <set>
using namespace std;

using ll = long long;
using ld = long double;

const int N = 10000005;

const int CCC = 50;
const ll MX = 1LL << 40LL;

ll collatz(ll a) {
    if (a & 1) {
        return a * 3 + 1;
    }
    return a >> 1;
}

int calc(ll a) {
    int cnt = 0;
    while (a < MX && a > 1 && cnt < CCC) {
        a = collatz(a);
        cnt++;
    }
    if (a >= MX || cnt >= CCC) {
        return 1000;
    }
    return cnt;
}

void solve() {
    ll x0;
    cin >> x0;
    int steps = 0;
    while (true) {
        int cc = calc(x0);
        if (cc < 100 - steps) {
            std::cout << "collatz" << endl;
        } else {
            if (x0 > MX) {
                std::cout << "collatz" << endl;
            } else {
                std::cout << "random" << endl;
            }
        }
        steps++;
        cin >> x0;
        if (x0 == 0) {
            exit(0);
        }
        if (x0 == 1) {
           break;
        }
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout << setprecision(15);
    ll t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}