#include <bits/stdc++.h>
using namespace std;
#define int long long
using ld = long double;

struct point {
    ld x, y;

    explicit point(ld x = 0, ld y = 0) : x(x), y(y) {
    }

    point(point a, point b) {
        x = b.x - a.x;
        y = b.y - a.y;
    }

    point operator+(point p) const {
        return point(x + p.x, y + p.y);
    }

    point operator-(point p) const {
        return point(x - p.x, y - p.y);
    }

    point operator*(ld k) const {
        return point(x * k, y * k);
    }

    ld len() const {
        return sqrt(x * x + y * y);
    }

    ld operator*(point p) const {
        return x * p.x + y * p.y;
    }

    ld operator%(point p) const {
        return x * p.y - y * p.x;
    }
};

istream& operator>>(istream& is, point& p) {
    is >> p.x >> p.y;
    return is;
}

ostream& operator<<(ostream& os, const point& p) {
    os << (int) p.x << ' ' << (int) p.y;
    return os;
}

ld angle(point a, point b) {
    return atan2(a % b, a * b);
}

///Проверка на пересечение отрезков
bool check(point a, point b, point c, point d) {
    if ((point(a, b) % point(a, c)) * (point(a, b) % point(a, d)) <= 0 &&
        (point(c, d) % point(c, a)) * (point(c, d) % point(c, b)) <= 0) {
        ld x1, x2, y1, y2;
        x1 = max(min(a.x, b.x), min(c.x, d.x)), x2 = min(max(a.x, b.x), max(c.x, d.x));
        y1 = max(min(a.y, b.y), min(c.y, d.y)), y2 = min(max(a.y, b.y), max(c.y, d.y));
        return (x1 <= x2) && (y1 <= y2);
        }
    return false;
}

///От точки до точки
ld dist(point a, point b) {
    return point(a, b).len();
}

signed main() {
    // Queen of Wands
    // Knight of Swords
    // The Fool
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    string a = "ABCDEFG";
    for (int i = 0; i < 6; ++i) {
        a += "ABCDEFG";
    }
    a += "ABC";
    int t;
    cin >> t;
    while (t--) {
        string s;
        cin >> s;
        int v = 0;
        bool aboba = false;
        for (int start = 0; start < a.length(); ++start) {
            v = start;
            bool can = true;
            for (char c : s) {
                bool good = false;
                for (int i = 0; i < 4; i++) {
                    if (v - i >= 0) {
                        if (a[v - i] == c) {
                            good = true;
                            v -= i;
                            break;
                        }
                    }
                    if (v + i < 52) {
                        if (a[v + i] == c) {
                            good = true;
                            v += i;
                            break;
                        }
                    }
                }
                if (!good) {
                    can = false;
                    break;
                }
            }
            if (can) {
                aboba = true;
                cout << "Yes\n";
                break;
            }
        }
        if (!aboba) {
            cout << "No\n";
        }
    }
}