#include <bits/stdc++.h>
using namespace std;

using ll = long long;
using pll = pair<ll, ll>;
using vi = vector<ll>;
using vvi = vector<vi>;

struct field  {
    vector<vi> data;
    int n;

    field(int _n, bool read=false) : data(2 * _n - 1), n(_n) {
        for(int i=0; i<n - 1; ++i) {
            data[i] = vi(n + i);
            if (read) {
                for(int j=0; j<data[i].size(); ++j){
                    cin >> data[i][j];
                }
            }
        }
        data[n - 1] = vi(2 * n - 1);
        if(read) {
            for(int j=0; j<data[n - 1].size(); ++j){
                cin >> data[n - 1][j];
            }
        }
        for(int i=0; i<n - 1; ++i) {
            data[n + i] = vi(2 * n - 2 - i);
            if(read) {
                for(int j=0; j<data[n + i].size(); ++j){
                    cin >> data[n + i][j];
                }
            }
        }
    }

    friend ostream& operator<<(ostream& stream, const field& f) {
        for(auto& i : f.data) {
            for(auto& j : i) {
                stream << j << " ";
            }
            stream << "\n";
        }
        return stream;
    }
};

struct tr {
    vector<vi> data;
    int n;

    tr(int _n, int pos, field f) : data(_n), n(_n)  {
        for(int i=0; i<n; ++i) {
            data[i] = vi(n - i);
        }

        if(pos > 2) {
            for(auto& i : f.data) {
                reverse(i.begin(), i.end());
            }
            for(int i=0; i<n; ++i) {
                f.data[i] = f.data[2 * n - 2 - i];
            }
            pos -= 3;
        }

        if(pos == 0) {
            for(int i=0; i<n; ++i) {
                for(int j=0; j<n-i; ++j) {
                    data[i][j] = f.data[n - 1 - j][i];
                }
            }
        }

        if (pos == 1) {
            for(int i=0; i<n; ++i) {
                for(int j=0; j<n-i; ++j) {
                    data[i][j] = f.data[i][j + i];
                }
            }
        }

        if (pos == 2) {
            for(int i=0; i<n; ++i) {
                for(int j=0; j<n-i; ++j) {
                    data[i][j] = f.data[j + i][n - 1 + j];
                }
            }
        }
    }

    void transpose() {
        for(auto& i : data) {
            reverse(i.begin(), i.end());
        }
    }

    void write(field& f, int pos) {
        if(pos == 0) {
            for(int i=0; i<n; ++i) {
                for(int j=0; j<n-i; ++j) {
                    f.data[n - 1 - j][i] = data[i][j];
                }
            }
        }

        if (pos == 1) {
            for(int i=0; i<n; ++i) {
                for(int j=0; j<n-i; ++j) {
                    f.data[i][j + i] = data[i][j];
                }
            }
        }

        if (pos == 2) {
            for(int i=0; i<n; ++i) {
                for(int j=0; j<n-i; ++j) {
                    f.data[j + i][n - 1 + j] = data[i][j];
                }
            }
        }

        if(pos == 3) {
            for(int i=0; i<n; ++i) {
                for(int j=0; j<n-i; ++j) {
                    f.data[n - 1 + j][2 * n - 2 - i - j] = data[i][j];
                }
            }
        }

        if (pos == 4) {
            for(int i=0; i<n; ++i) {
                for(int j=0; j<n-i; ++j) {
                    f.data[2 * n - 2 - i][n - 1 - j] = data[i][j];
                }
            }
        }

        if(pos == 5) {
            for(int i=0; i<n; ++i) {
                for(int j=0; j<n-i; ++j) {
                    f.data[2 * n - 2 - j - i][i] = data[i][j];
                }
            }
        }
    }
};

template<typename T>
void shift_l(vector<T>& v) {
    T fst = v[0];
    v.erase(v.begin());
    v.push_back(fst);
}

template<typename T>
void shift_r(vector<T>& v) {
    for(int i=0; i<5;  ++i) {
        shift_l(v);
    }
}

void solve() {
    int n; cin >> n;
    field f(n, true);
    vector<tr> v;
    for(int i=0; i<6; ++i) {
        v.emplace_back(n, i, f);
    }

    string s; cin >> s;
    vector<bool> transpose(6);
    vi ind(6);
    for(int i=0; i<6; ++i) {
        ind[i] = i;
    }

    for(auto c : s) {
        if(c == 'L') {
            shift_l(transpose);
            shift_l(ind);
        }
        if(c == 'R') {
            shift_r(transpose);
            shift_r(ind);
        }
        if(c == 'T') {
            for(int i=0; i<6; ++i) {
                transpose[i] = !transpose[i];
            }
            swap(transpose[0], transpose[2]);
            swap(ind[0], ind[2]);
            swap(transpose[5], transpose[3]);
            swap(ind[5], ind[3]);
        }
    }

    field f2(n);

    for(int i=0; i<6; ++i) {
        int initial = ind[i];
        if(transpose[i]) {
            v[initial].transpose();
        }
        v[initial].write(f2, i);
    }

    cout << f2;
}


int main() {
    // freopen("output.txt", "w", stdout);
    ios_base::sync_with_stdio(false);
    cout.tie(nullptr);
    int t = 1; // cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}
