#include <iostream>
#include <cstdint>

#define int long long

int MOD = 1000000000 + 7;

int fact[2000001];

int factorial(int n) {
    if (n >= 0){
        return fact[n];
    }
    return 1;
}

int mod_pow(int base) {
    int result = 1;
    int exp = MOD - 2;
    base %= MOD;
    while (exp > 0) {
        if (exp % 2 == 1)
            result = (result * base) % MOD;
        base = (base * base) % MOD;
        exp /= 2;
    }
    return result;
}

int32_t main() {
    int t, p, m;
    fact[0] = 1;
    for (int i = 1; i <= 2000000; i++){
        fact[i] = (fact[i - 1] * i) % MOD;
    }
    std::cin >> t;
    while (t--) {
        std::cin >> p >> m;
        int res = 0;
        int count = 0;
        for (int k = 2; k <= p + m + 1; ++k) {
            int a = (k - 1) * factorial(2 * p + m - 2) / factorial(2 * p + m - 2 - k + 2);
            res += k * a;
            count += a;
        }
        count = count % MOD;
        res = res % MOD;
        std::cout << (res * mod_pow(count)) % MOD << std::endl;
    }
}
