def to_coords(a):
    coords = {}
    n = len(a)
    mid = n // 2
    for i, row in enumerate(a):
        start = -mid + max(0, mid - i)
        for j, val in enumerate(row):
            q = start + j
            r = i - mid
            coords[(q, r)] = val
    return coords


def to_sota(coords):
    rs = [r for _, r in coords]
    min_r, max_r = min(rs), max(rs)
    result = []
    for r in range(min_r, max_r + 1):
        row = [v for (q, rr), v in sorted(coords.items()) if rr == r]
        result.append(row)
    return result


def T(a):
    return {(-q - r, r): v for (q, r), v in a.items()}


def R(a):
    return {(-r, q + r): v for (q, r), v in a.items()}


def L(a):
    return {(q + r, -q): v for (q, r), v in a.items()}


D6 = [[0]*12 for _ in range(12)]

for i in range(6):
    for j in range(6):
        D6[i][j] = (i + j) % 6
for i in range(6):
    for j in range(6, 12):
        D6[i][j] = (i + j) % 6 + 6
for i in range(6, 12):
    for j in range(6, 12):
        D6[i][j] = (i - j) % 6
for i in range(6, 12):
    for j in range(6):
        D6[i][j] = ((j - 6 - i) % 6) + 6


mapping = {"R": 1, "L": 5, "T": 6}
how = {0: "", 1: "R", 2: "RR", 3: "RRR", 4: "LL", 5: "L", 6: "T", 7: "TR", 8: "TRR", 9: "TRRR", 10: "TLL", 11: "TL"}

n = int(input())
a = [list(map(int, input().split())) for _ in range(2 * n - 1)]
s = input().strip()

composition = 0
for c in s:
    composition = D6[composition][mapping[c]]

a = to_coords(a)
for c in how[composition]:
    if c == 'R':
        a = R(a)
    elif c == 'L':
        a = L(a)
    elif c == 'T':
        a = T(a)
a = to_sota(a)

for row in a:
    print(*row)
