#include <iostream>
#include <vector>
#include <map>
#include <set>
#include <string>
#include <algorithm>
#include <sstream>

using namespace std;

typedef pair<int, int> Coord;

map<Coord, int> to_coords(const vector<vector<int>>& a) {
    map<Coord, int> coords;
    int n = a.size();
    int mid = n / 2;
    for (int i = 0; i < n; i++) {
        int start = -mid + max(0, mid - i);
        for (int j = 0; j < a[i].size(); j++) {
            int q = start + j;
            int r = i - mid;
            coords[make_pair(q, r)] = a[i][j];
        }
    }
    return coords;
}

vector<vector<int>> to_sota(const map<Coord, int>& coords) {
    set<int> rs;
    for (const auto& entry : coords) {
        rs.insert(entry.first.second);
    }
    if (rs.empty()) {
        return {};
    }
    int min_r = *rs.begin();
    int max_r = *rs.rbegin();
    
    map<int, vector<int>> rows;
    for (const auto& entry : coords) {
        int q = entry.first.first;
        int r = entry.first.second;
        rows[r].push_back(entry.second);
    }
    
    vector<vector<int>> result;
    for (int r = min_r; r <= max_r; r++) {
        result.push_back(rows[r]);
    }
    return result;
}

map<Coord, int> T(const map<Coord, int>& a) {
    map<Coord, int> new_coords;
    for (const auto& entry : a) {
        int q = entry.first.first;
        int r = entry.first.second;
        int new_q = -q - r;
        int new_r = r;
        new_coords[make_pair(new_q, new_r)] = entry.second;
    }
    return new_coords;
}

map<Coord, int> R(const map<Coord, int>& a) {
    map<Coord, int> new_coords;
    for (const auto& entry : a) {
        int q = entry.first.first;
        int r = entry.first.second;
        int new_q = -r;
        int new_r = q + r;
        new_coords[make_pair(new_q, new_r)] = entry.second;
    }
    return new_coords;
}

map<Coord, int> L(const map<Coord, int>& a) {
    map<Coord, int> new_coords;
    for (const auto& entry : a) {
        int q = entry.first.first;
        int r = entry.first.second;
        int new_q = q + r;
        int new_r = -q;
        new_coords[make_pair(new_q, new_r)] = entry.second;
    }
    return new_coords;
}

int main() {
    int D6[12][12] = {0};
    
    for (int i = 0; i < 6; i++) {
        for (int j = 0; j < 6; j++) {
            D6[i][j] = (i + j) % 6;
        }
    }
    for (int i = 0; i < 6; i++) {
        for (int j = 6; j < 12; j++) {
            D6[i][j] = (i + j) % 6 + 6;
        }
    }
    for (int i = 6; i < 12; i++) {
        for (int j = 6; j < 12; j++) {
            D6[i][j] = (6 + (i - j)) % 6;
        }
    }
    for (int i = 6; i < 12; i++) {
        for (int j = 0; j < 6; j++) {
            D6[i][j] = ((6 - (i - 6) + j) % 6) + 6;
        }
    }
    
    map<char, int> mapping = { {'R', 1}, {'L', 5}, {'T', 6} };
    map<int, string> how = {
        {0, ""}, {1, "R"}, {2, "RR"}, {3, "RRR"}, {4, "LL"}, {5, "L"},
        {6, "T"}, {7, "TR"}, {8, "TRR"}, {9, "TRRR"}, {10, "TLL"}, {11, "TL"}
    };
    
    int n;
    cin >> n;
    cin.ignore();
    
    vector<vector<int>> a;
    for (int i = 0; i < 2 * n - 1; i++) {
        string line;
        getline(cin, line);
        stringstream ss(line);
        vector<int> row;
        int num;
        while (ss >> num) {
            row.push_back(num);
        }
        a.push_back(row);
    }
    
    string s;
    getline(cin, s);
    
    int composition = 0;
    for (char c : s) {
        composition = D6[composition][mapping[c]];
    }
    
    auto coords = to_coords(a);
    string operations = how[composition];
    for (char c : operations) {
        if (c == 'R') {
            coords = R(coords);
        } else if (c == 'L') {
            coords = L(coords);
        } else if (c == 'T') {
            coords = T(coords);
        }
    }
    a = to_sota(coords);
    
    for (const auto& row : a) {
        for (int val : row) {
            cout << val << " ";
        }
        cout << endl;
    }
    
    return 0;
}