#include <cmath>
#include <iostream>
#include <limits>
#include <vector>

using ll = long long;

struct point {
  ll x;
  ll y;
};


ll dst(point x, point y) {
  return (x.x - y.x) * (x.x - y.x) - (x.y - y.y) * (x.y - y.y);
}

void print(point minX, point maxX) {
  int b = (maxX.y - minX.y);
  int a = (maxX.x - minX.x);
  std::cout << a << " " << b << " " << 0 << "\n";
  std::cout << a << " " << b << " " << - (b * b + a * a) << "\n";
}

int main() {
  int n;
  std::cin >> n;
  point xx, yy;
  std::vector<point> pts(n);
  for (size_t i = 0; i < n; ++i) {
    ll x, y;
    std::cin >> x >> y;
    pts[i] = {x, y};
  }
  xx = pts[0];
  yy = pts[1];
  ll maxDst = dst(xx, yy);
  for (size_t i = 0; i < n; ++i) {
    for (size_t j = 0; j < n; ++j) {
      if (maxDst < dst(pts[i], pts[j])) {
        maxDst = dst(pts[i], pts[j]);
        xx = pts[i];
        yy = pts[j];
      }
    }
  }
  print(xx, yy);
}