import java.util.*;

public class Main {

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        int n = sc.nextInt();

        Map<Character, Integer> map = Map.of(
                'A', 3,
                'B', 2,
                'C', 1,
                'D', 0,
                'E', 1,
                'F', 2,
                'G', 3
        );

        while (sc.hasNext()) {
            String line = sc.next();
            if (line.length() == 1) {
                System.out.println("YES");
                continue;
            }

            boolean flag = true;
            int pos = 26;
            char ch = line.charAt(0);

            for (int i = 1; i < line.length(); i++) {
                char next = line.charAt(i);
                int move = Math.abs(map.get(ch) - map.get(next));
                move = Math.min(move, 7 - move);

                if (move > 2) {
                    flag = false;
                    break;
                }

                if (map.get(next) > map.get(ch)) pos += move;
                else pos -= move;

                if (pos < 0 || pos > 51) {
                    flag = false;
                    break;
                }

                ch = next;
            }

            System.out.println(flag ? "YES" : "NO");
        }
    }
}
