#include <exception>
#pragma GCC optimize("O3")
#include <iostream>
#include <set>
#include <vector>
#include <algorithm>

using namespace std;

template<typename T, typename U>
void insert_sorted(std::vector<T>& vec, const U& value) {
    auto it = std::upper_bound(vec.begin(), vec.end(), value);
    vec.insert(it, value);
}

int main() {
    long long n, s;

    bool a[999984] = { };
    
    vector<int> V;
    V.reserve(110000); 

    cin >> n >> s;

    for (long long i = 0; i < n; i++) {
        s = (s * 618023 + 1) % 999983;

        long long j = 0;

        for (const auto v : V) {
            if (s - v < v) {
                break;
            }

            if (a[s - v]) {
                j++;
            }
        }
            
        if (j % 2 == 0 && !a[s]) {
            insert_sorted(V, s);
            a[s] = true;
        }
    }

    cout << V.size();

    return 0;
}
