#include <time.h>

#include <algorithm>
#include <cassert>
#include <chrono>
#include <cmath>
#include <complex>
#include <cstring>
#include <fstream>
#include <iomanip>
#include <iostream>
#include <map>
#include <numeric>
#include <queue>
#include <random>
#include <set>
#include <stack>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <vector>
#include <bitset>
using namespace std::chrono;

#define all(x) x.begin(), x.end()

using namespace std;

typedef long long ll;
typedef pair<int, int> pi;
typedef pair<ll, ll> pl;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<bool> vb;
typedef vector<pi> vpi;

bool inside(ll value, ll left, ll right) {
  return (left <= value && value <= right);
}

ll gcd(ll a, ll b) {
  while (b > 0) {
    ll tmp = b;
    b = a % b;
    a = tmp;
  }
  return a;
}

ll bin_pow(ll a, ll exp, ll mod) {
  ll res = 1;
  while (exp) {
    if (exp & 1) res = (res * a) % mod;
    a = (a * a) % mod;
    exp >>= 1;
  }
  return res;
}

int inverse(int a, int m) {
  int g = m, r = a, x = 0, y = 1;
  while (r != 0) {
    int q = g / r;
    g %= r;
    swap(g, r);
    x -= q * y;
    swap(x, y);
  }
  return x < 0 ? x + m : x;
}

const int INF = 2e9 + 1;
const ll LINF = 9e18;
const int MOD = 998244353;  // 1e9 + 7;
const int N = 2e7 + 500, M = 700;

ll mulmod(ll a, ll b, ll mod) {
  ll x = 0, y = a % mod;
  while (b > 0) {
    if (b % 2 == 1) {
      x = (x + y) % mod;
    }
    y = (y * 2) % mod;
    b /= 2;
  }
  return x % mod;
}

void solve() {
  string s;
  cin >> s;
  string all = "ABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABC";
  
  std::map<char, int> map;
  map.insert({'A', 1});
  map.insert({'B', 2});
  map.insert({'C', 3});
  map.insert({'D', 4});
  map.insert({'E', 5});
  map.insert({'F', 6});
  map.insert({'G', 7});
  int ans = 0;
  std::map<std::pair<int, int>, int> a;
  a.insert({{1, 1}, 0});
  a.insert({{1, 2}, 1});
  a.insert({{1, 3}, 2});
  a.insert({{1, 4}, 3});
  a.insert({{1, 5}, -3});
  a.insert({{1, 6}, -2});
  a.insert({{1, 7}, -1});
  a.insert({{2, 1}, -1});
  a.insert({{2, 2}, 0});
  a.insert({{2, 3}, 1});
  a.insert({{2, 4}, 2});
  a.insert({{2, 5}, 3});
  a.insert({{2, 6}, -3});
  a.insert({{2, 7}, -2});
  a.insert({{3, 1}, -2});
  a.insert({{3, 2}, -1});
  a.insert({{3, 3}, 0});
  a.insert({{3, 4}, 1});
  a.insert({{3, 5}, 2});
  a.insert({{3, 6}, 3});
  a.insert({{3, 7}, -3});
  a.insert({{4, 1}, -3});
  a.insert({{4, 2}, -2});
  a.insert({{4, 3}, -1});
  a.insert({{4, 4}, 0});
  a.insert({{4, 5}, 1});
  a.insert({{4, 6}, 2});
  a.insert({{4, 7}, 3});
  a.insert({{5, 1}, 3});
  a.insert({{5, 2}, -3});
  a.insert({{5, 3}, -2});
  a.insert({{5, 4}, -1});
  a.insert({{5, 5}, 0});
  a.insert({{5, 6}, 1});
  a.insert({{5, 7}, 2});
  a.insert({{6, 1}, 2});
  a.insert({{6, 2}, 3});
  a.insert({{6, 3}, -3});
  a.insert({{6, 4}, -2});
  a.insert({{6, 5}, -1});
  a.insert({{6, 6}, 0});
  a.insert({{6, 7}, 1});
  a.insert({{7, 1}, 1});
  a.insert({{7, 2}, 2});
  a.insert({{7, 3}, 3});
  a.insert({{7, 4}, -3});
  a.insert({{7, 5}, -2});
  a.insert({{7, 6}, -1});
  a.insert({{7, 7}, 0});

  int i;
  if (map[s[0]] < 4) {
    i = 8;
  } else {
    i = 7;
  }
  int x = i;
  while (i--) {
    int index = map[s[0]] + 7 * i - 1;
    for (int j = 1; j < s.size(); j++) {
      index += a[{map[s[j - 1]], map[s[j]]}];
      if (index < 0 || index > all.size() - 1) {
        ans++;
        break;
      }
    }
  }
  if (ans == x) {
    cout << "No\n";
    return;
  }
  cout << "Yes\n";
}

int main() {
  ios_base::sync_with_stdio(false), cin.tie(0);
#ifdef LOCAL
  freopen("input.in", "r", stdin);
#endif
  int t = 1;
  cin >> t;
  for (int i = 0; i < t; i++) {
    string s = "Testcase #";
    // s += ('0' + i);
    // print(s, 2);
    solve();
    // print("-----------\n");
  }
}