#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <map>
#include <ctime>
#include <random>
#include <climits>
#include <cmath>

using namespace std;

typedef long long ll;
typedef long double ld;

ld PI = std::acos((ld)-1);
const ll mod = 1e9 + 7;

ll powMod2(ll a, ll n, ll mod) {
    if (n == 0)
        return 1;
    if (n == 1)
        return a;
    ll d = powMod2(a, n / 2, mod);
    d = (d * d) % mod;
    if (n & 1)
        d = (d * a) % mod;
    return d;
}

ll powMod(ll a, ll n, ll mod) {
    if (a == 0)
        return 0;
    if (a == 1)
        return 1;
    return powMod2(a % mod, (n % (mod - 1) + mod - 1) % (mod - 1), mod);
}

struct intp {
    ll x;
    intp(ll a = 0) {
        x = (a % mod + mod) % mod;
    }
    intp operator+(intp& other) {
        return intp(x + other.x);
    }
    intp operator-(intp& other) {
        return intp(x - other.x);
    }
    intp operator*(intp& other) {
        return intp(x * other.x);
    }
    intp operator/(intp& other) {
        return intp(x * powMod(other.x, mod - 2, mod));
    }
};

int main() {
    std::ios_base::sync_with_stdio(false);
    int n;
    std::cin >> n;
    for(int i = 0;i <= n; ++i) {
        std::cout << std::abs(i - 9 * n / 10) << " " << n - std::abs(i - n / 10) << "\n";
    }
}