#include <iostream>
#include <vector>
#include <cmath>
#include <iomanip>
#include <deque>

#define USE_MATH_DEFINES

using namespace std;

typedef long long ll;
typedef long double ld;

const ll mod = 2286661337;

ll bin_pow(ll a, ll n) {
    if (n == 0) {
        return 1;
    } else if (n % 2 == 1) {
        return a * bin_pow(a, n - 1) % mod;
    } else {
        ll b = bin_pow(a, n / 2);
        return b * b % mod;
    }
}

struct point{
    ll x, y;
};

ll dist(point a, point b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

void solve() {
    int n; cin >> n;
    vector <vector <int>> a(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; i++) {
        if (i <= n - 1) {
            a[i].resize(n + i);
        } else {
            a[i].resize(n + 2 * n - 2 - i);
        }
        for (int j = 0; j < a[i].size(); j++) {
            cin >> a[i][j];
        }
    }
    vector <vector <int>> c(n);
    for (int i = 0; i < n; i++) {
        if (i == n - 1) {
            c[i].push_back(a[n - 1][n - 1]);
            break;
        }
        for (int j = i; j < a[i].size() - i; j++) {
            c[i].push_back(a[i][j]);
        }
        for (int j = i + 1; j < n; j++) {
            c[i].push_back(a[j][a[j].size() - i - 1]);
        }
        for (int j = n; j < 2 * n - i - 1; j++) {
            c[i].push_back(a[j][a[j].size() - i - 1]);
        }
        for (int j = a[2 * n - i - 2].size() - i - 2; j >= i; j--) {
            c[i].push_back(a[2 * n - i - 2][j]);
        }
        for (int j = 2 * n - i - 3; j >= n - 1; j--) {
            c[i].push_back(a[j][i]);
        }
        for (int j = n - 2; j >= i + 1; j--) {
            c[i].push_back(a[j][i]);
        }
    }
    bool dir = true;
    int sum = 0;
    string s; cin >> s;
    cin >> s;
    for (int i = 0; i < s.size(); i++) {
        if (s[i] == 'L') {
            if (dir) {
                sum++;
            } else {
                sum--;
            }
        } else if (s[i] == 'R') {
            if (dir) {
                sum--;
            } else {
                sum++;
            }
        } else {
            if (dir) {
                sum++;
            } else {
                sum--;
            }
            dir = !dir;
        }
    }
    vector <vector <int>> nc(n);
    for (int i = 0; i < n; i++) {
        int st = ((sum * (n - i - 1) % c[i].size()) + c[i].size()) % c[i].size();
        if (dir) {
            for (int j = st; j < c[i].size(); j++) {
                nc[i].push_back(c[i][j]);
            }
            for (int j = 0; j < st; j++) {
                nc[i].push_back(c[i][j]);
            }
        } else {
            for (int j = st; j >= 0; j--) {
                nc[i].push_back(c[i][j]);
            }
            for (int j = c[i].size() - 1; j > st; j--) {
                nc[i].push_back(c[i][j]);
            }
        }
    }
    c = nc;
    vector <deque<int>> ans(1);
    ans[0] = {c[n - 1][0]};
    for (int i = n - 2; i >= 0; i--) {
        deque <int> up, down;
        for (int j = 0; j < n - i; j++) {
            up.push_back(c[i][j]);
        }
        for (int j = 0; j < n - i; j++) {
            down.push_front(c[i][c[i].size() / 2 + j]);
        }
        int front = c[i].size() - 1, back = n - i;
        for (int j = 0; j < ans.size(); j++) {
            ans[j].push_front(c[i][front]);
            ans[j].push_back(c[i][back]);
            front--;
            back++;
        }
        ans.insert(ans.begin(), up);
        ans.push_back(down);
    }
    for (auto i : ans) {
        for (auto j : i) cout << j << ' ';
        cout << '\n';
    }
}

int main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t = 1;
    //cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}