#include <iostream>
#include <vector>
#include <cmath>
#include <iomanip>
#include <deque>

#define USE_MATH_DEFINES

using namespace std;

typedef long long ll;
typedef long double ld;

const ll mod = 1000000007;

ll bin_pow(ll a, ll n) {
    if (n == 0) {
        return 1;
    } else if (n % 2 == 1) {
        return a * bin_pow(a, n - 1) % mod;
    } else {
        ll b = bin_pow(a, n / 2);
        return b * b % mod;
    }
}

struct point{
    ll x, y;
};

ll dist(point a, point b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

vector <ll> fact(4e6);

void solve() {
    ll p, m; cin >> p >> m;
    ll ans = bin_pow(2, p);
    ans = ans * ans % mod;
    ans = ans * (m + 2 * p + 1) % mod;
    ans = (ans * fact[p] % mod) * fact[p] % mod;
    ans = ans * bin_pow(fact[2 * p + 1], mod - 2) % mod;
    cout << ans << "\n";
}

int main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    fact[0] = fact[1] = 1;
    for (int i = 2; i < 4e6; i++) {
        fact[i] = fact[i - 1] * i;
        fact[i] %= mod;
    }
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}