#include <bits/stdc++.h>
using namespace std;
#define int long long
mt19937 rng(69);
const int maxn = 6e5;
const int maxc = 1e5;
int cost[maxn + 1];
int dp[maxn + 1];
unordered_map<int, int> npdp;
int calc_cost(int x) {
    int cnt = 0;
    while (x > 0) {
        cnt++;
        x /= 10;
    }
    return cnt;
}
int dfs(int x) {
    if (x <= maxc) {
        if (dp[x] != 1e9) {
            return dp[x];
        }
        if (x % 2 == 0) {
            dp[x] = dfs(x / 2) + cost[x];
            return dp[x];
        } else {
            dp[x] = dfs(3 * x + 1) + cost[x];
            return dp[x];
        }
    } else {
        if (npdp.find(x) != npdp.end()) {
            return npdp[x];
        }
        if (x % 2 == 0) {
            npdp[x] = dfs(x / 2) + calc_cost(x);
            return npdp[x];
        } else {
            npdp[x] = dfs(3 * x + 1) + calc_cost(x);
            return npdp[x];
        }
    }
}
int add_cost(int x) {
    if (x <= maxc) {
        return cost[x];
    } else {
        return calc_cost(x);
    }
}
int get_dp(int x) {
    if (x <= maxc) {
        return dp[x];
    } else if (npdp.find(x) != npdp.end()) {
        return npdp[x];
    } else {
        dfs(x);
        return npdp[x];
    }
}
int binpow(int a, int n) {
    int res = 1;
    while (n > 0) {
        if (n & 1) {
            res *= a;
        }
        a *= a;
        n /= 2;
    }
    return res;
}
int randomik(int x) {
    int l = 3 * x + 1;
    int r = 6 * x + 1;
    int minim = 1e9;
    for (int it = 0; it < 30; it++) {
        int X = rng() % (r - l) + l;
        minim = min(minim, get_dp(X));
    }
    return minim;
}
void solve() {
    int x;
    cin >> x;
    int c = 0;
    int status;
    while (x > 1) {
        if (get_dp(x) < randomik(x)) {
            cout << "Collatz" << endl;
            c += add_cost(x);
            cin >> status;
            x = status;
            if (status == 0 || status == 1) {
                break;
            }
        } else {
            cout << "random" << endl;
            cin >> status;
            c += add_cost(x);
            x = status;
            if (status == 0 || status == 1) {
                break;
            }
        }
    }
}
signed main() {
    for (int step = 1; step <= 5; step++) {
        int start = binpow(10, step - 1), end = binpow(10, step);
        for (int j = start; j < end; j++) {
            cost[j] = step;
            dp[j] = 1e9;
        }
    }
    dp[1] = 1;
    queue<int> q;
    for (int i = 2; i <= maxn; i++) {
        int x = i;
        dfs(x);
    }
    int test;
    cin >> test;
    while (test--) {
        solve();
    }
}