#include <iostream>
#include <vector>
#include <tuple>
#include <cmath>    
#include <limits>   

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<pair<long long, long long>> points(n);
    for (int i = 0; i < n; i++)
        cin >> points[i].first >> points[i].second;

    long long best_a = 0, best_b = 0, best_c1 = 0, best_c2 = 0;
    long double best_ratio = -1.0L;

    for (int i = 0; i < n; i++) {
        long long x1 = points[i].first;
        long long y1 = points[i].second;

        for (int j = i + 1; j < n; j++) {
            long long x2 = points[j].first;
            long long y2 = points[j].second;

            long long a = x2 - x1;
            long long b = y2 - y1;
            if (a == 0 && b == 0) continue;

            long long t_min = points[0].first * a + points[0].second * b;
            long long t_max = t_min;

            for (int k = 1; k < n; k++) {
                long long t = points[k].first * a + points[k].second * b;
                if (t < t_min) t_min = t;
                if (t > t_max) t_max = t;
            }

            long long dist2 = (t_max - t_min) * (t_max - t_min);
            long long denom = a * a + b * b;

            long double ratio = static_cast<long double>(dist2) / static_cast<long double>(denom);

            if (ratio > best_ratio) {
                best_ratio = ratio;
                best_a = a;
                best_b = b;
                best_c1 = -t_min;
                best_c2 = -t_max;
            }
        }
    }
    if (best_a < 0 || (best_a == 0 && best_b < 0)) {
        best_a = -best_a;
        best_b = -best_b;
        best_c1 = -best_c1;
        best_c2 = -best_c2;
    }

    cout << best_a << " " << best_b << " " << best_c1 << "\n";
    cout << best_a << " " << best_b << " " << best_c2 << "\n";

    return 0;
}
