#include <iostream>
#include <vector>
#include <numeric>
#include <algorithm>

void fast_io() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);
}

namespace NTT {
    const int MOD = 998244353;
    const int G = 3;
    const int MAX_N = 1 << 21;

    long long power(long long base, long long exp) {
        long long res = 1;
        base %= MOD;
        while (exp > 0) {
            if (exp % 2 == 1) res = (res * base) % MOD;
            base = (base * base) % MOD;
            exp /= 2;
        }
        return res;
    }

    long long modInverse(long long n) {
        return power(n, MOD - 2);
    }

    void ntt(std::vector<long long>& a, bool invert) {
        int n = a.size();
        for (int i = 1, j = 0; i < n; i++) {
            int bit = n >> 1;
            for (; j & bit; bit >>= 1)
                j ^= bit;
            j ^= bit;
            if (i < j)
                std::swap(a[i], a[j]);
        }

        for (int len = 2; len <= n; len <<= 1) {
            long long wlen = power(G, (MOD - 1) / len);
            if (invert) wlen = modInverse(wlen);
            for (int i = 0; i < n; i += len) {
                long long w = 1;
                for (int j = 0; j < len / 2; j++) {
                    long long u = a[i + j], v = (a[i + j + len / 2] * w) % MOD;
                    a[i + j] = (u + v) % MOD;
                    a[i + j + len / 2] = (u - v + MOD) % MOD;
                    w = (w * wlen) % MOD;
                }
            }
        }
        if (invert) {
            long long n_inv = modInverse(n);
            for (long long& x : a)
                x = (x * n_inv) % MOD;
        }
    }

    std::vector<long long> multiply(const std::vector<bool>& a_bool, const std::vector<bool>& b_bool) {
        std::vector<long long> a(a_bool.begin(), a_bool.end());
        std::vector<long long> b(b_bool.begin(), b_bool.end());
        int n = 1;
        while (n < a.size() + b.size()) n <<= 1;
        a.resize(n);
        b.resize(n);

        ntt(a, false);
        ntt(b, false);
        for (int i = 0; i < n; i++) a[i] = (a[i] * b[i]) % MOD;
        ntt(a, true);

        return a;
    }
}

const int PROBLEM_MOD = 999983;

int main() {
    fast_io();
    int n;
    long long s;
    std::cin >> n >> s;

    const int BLOCK_SIZE = 450;
    int total_elements = 0;

    std::vector<bool> p_total(PROBLEM_MOD, false);
    std::vector<bool> p_main(PROBLEM_MOD, false);
    std::vector<long long> conv_main(2 * PROBLEM_MOD, 0);
    std::vector<int> v_block;

    for (int i = 0; i < n; ++i) {
        if (i % BLOCK_SIZE == 0 && i > 0) {
            if (!v_block.empty()) {
                std::vector<bool> p_block(PROBLEM_MOD, false);
                for (int val : v_block) {
                    p_block[val] = true;
                }

                auto conv_main_block = NTT::multiply(p_main, p_block);
                auto conv_block_block = NTT::multiply(p_block, p_block);

                for (size_t k = 0; k < conv_main.size(); ++k) {
                    long long term1 = (k < conv_main_block.size()) ? (2 * conv_main_block[k]) : 0;
                    long long term2 = (k < conv_block_block.size()) ? conv_block_block[k] : 0;
                    conv_main[k] += term1 + term2;
                }

                for (int val : v_block) p_main[val] = true;
                v_block.clear();
            }
        }

        s = (s * 618023LL + 1) % PROBLEM_MOD;
        int cs = s;

        long long pairs_count = 0;

        if (cs < conv_main.size()) {
            pairs_count += conv_main[cs];
        }

        for (int a : v_block) {
            int b = cs - a;
            if (b >= 0 && b < PROBLEM_MOD && p_main[b]) {
                pairs_count += 2;
            }
        }

        for (int j = 0; j < v_block.size(); ++j) {
            for (int k = 0; k < v_block.size(); ++k) {
                if (v_block[j] + v_block[k] == cs) {
                    pairs_count++;
                }
            }
        }

        long long distinct_pairs = pairs_count;
        if (cs % 2 == 0 && p_total[cs / 2]) {
            distinct_pairs++;
        }
        distinct_pairs /= 2;

        if (distinct_pairs % 2 == 0) {
            if (!p_total[cs]) {
                p_total[cs] = true;
                v_block.push_back(cs);
                total_elements++;
            }
        }
    }

    std::cout << total_elements << std::endl;

    return 0;
}


// #include <iostream>
// #include <vector>
// #include <string>
// #include <algorithm>
//
// std::vector<std::vector<int>> R(const std::vector<std::vector<int>>& grid, int n, int rot) {
//     int mid = n - 1;
//     int q_new;
//     int r_new;
//     std::vector<std::vector<int>> new_grid(2 * n - 1);
//
//     for (int i = 0; i < 2 * n - 1; ++i) {
//         int len = n - abs(i - mid);
//         new_grid[i] = std::vector<int>(len);
//     }
//
//     for (int i = 0; i < 2 * n - 1; ++i) {
//         int r = i - mid;
//         int max_q = n - 1 - abs(r);
//         for (int j = 0; j < (int)grid[i].size(); ++j) {
//             int q = j - max_q;
//
//             switch (rot) {
//                 case 0:
//                     q_new = -r;
//                     r_new = q + r;
//                     break;
//                 case 1:
//                     q_new = q + r;
//                     r_new = -q;
//                     break;
//             }
//
//             int i_new = r_new + mid;
//             int max_q_new = n - 1 - abs(r_new);
//             int j_new = q_new + max_q_new;
//
//             new_grid[i_new][j_new] = grid[i][j];
//         }
//     }
//
//     return new_grid;
// }
//
// void T(const std::vector<std::vector<int>>& grid) {
//     // int mid = n - 1;
//     // std::vector<std::vector<int>> new_grid(2 * n - 1);
//     //
//     // for (int i = 0; i < 2 * n - 1; ++i) {
//     //     int len = n - abs(i - mid);
//     //     new_grid[i] = std::vector<int>(len);
//     // }
//
//     for (std::vector<int> row: grid) {
//         reverse(row.begin(), row.end());
//     }
// }
//
// int main() {
//     int n = 3;
//     std::vector<std::vector<int>> v;
//     int c;
//
//     for (int i = 0; i < 2 * n - 1; i++) {
//         v.push_back(std::vector<int>());
//         if (i < n) {
//             for (int j = 0; j < n + i; j++) {
//                 std::cin >> c;
//                 v[i].push_back(c);
//             }
//         }
//         else {
//             for (int j = 0; j < n - i + 4; j++) {
//                 std::cin >> c;
//                 v[i].push_back(c);
//             }
//         }
//     }
//     std::cout << 1;
//     v = R(v, n, 1);
//     // T(v);
//     std::cout << 2;
//     v = R(v, n, 0);
//
//     for (int i = 0; i < v.size(); i++) {
//         for (int j = 0; j < v[i].size(); j++) {
//             std::cout << v[i][j] << " ";
//         }
//         std::cout << std::endl;
//     }
// }