#include <iostream>
#include <vector>
using namespace std;

const long long MOD = 1'000'000'007LL;

long long modpow(long long a, long long e) {
    long long r = 1;
    a %= MOD;
    while (e > 0) {
        if (e & 1) r = r * a % MOD;
        a = a * a % MOD;
        e >>= 1;
    }
    return r;
}

long long invmod(long long x) {
    return modpow((x % MOD + MOD) % MOD, MOD - 2);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;

    while (t--) {
        long long p, m;
        cin >> p >> m;

        if (p == 0) {
            cout << 0 << "\n";
            continue;
        }

        long long numer = (2 * m) % MOD;
        long long den = (3 * p) % MOD;
        long long frac = numer * invmod(den) % MOD;

        long long result = (2 + frac) % MOD;
        cout << result << endl;
    }
}

// #include <iostream>
// #include <vector>
// #include <string>
// #include <algorithm>
//
// std::vector<std::vector<int>> R(const std::vector<std::vector<int>>& grid, int n, int rot) {
//     int mid = n - 1;
//     int q_new;
//     int r_new;
//     std::vector<std::vector<int>> new_grid(2 * n - 1);
//
//     for (int i = 0; i < 2 * n - 1; ++i) {
//         int len = n - abs(i - mid);
//         new_grid[i] = std::vector<int>(len);
//     }
//
//     for (int i = 0; i < 2 * n - 1; ++i) {
//         int r = i - mid;
//         int max_q = n - 1 - abs(r);
//         for (int j = 0; j < (int)grid[i].size(); ++j) {
//             int q = j - max_q;
//
//             switch (rot) {
//                 case 0:
//                     q_new = -r;
//                     r_new = q + r;
//                     break;
//                 case 1:
//                     q_new = q + r;
//                     r_new = -q;
//                     break;
//             }
//
//             int i_new = r_new + mid;
//             int max_q_new = n - 1 - abs(r_new);
//             int j_new = q_new + max_q_new;
//
//             new_grid[i_new][j_new] = grid[i][j];
//         }
//     }
//
//     return new_grid;
// }
//
// void T(const std::vector<std::vector<int>>& grid) {
//     // int mid = n - 1;
//     // std::vector<std::vector<int>> new_grid(2 * n - 1);
//     //
//     // for (int i = 0; i < 2 * n - 1; ++i) {
//     //     int len = n - abs(i - mid);
//     //     new_grid[i] = std::vector<int>(len);
//     // }
//
//     for (std::vector<int> row: grid) {
//         reverse(row.begin(), row.end());
//     }
// }
//
// int main() {
//     int n = 3;
//     std::vector<std::vector<int>> v;
//     int c;
//
//     for (int i = 0; i < 2 * n - 1; i++) {
//         v.push_back(std::vector<int>());
//         if (i < n) {
//             for (int j = 0; j < n + i; j++) {
//                 std::cin >> c;
//                 v[i].push_back(c);
//             }
//         }
//         else {
//             for (int j = 0; j < n - i + 4; j++) {
//                 std::cin >> c;
//                 v[i].push_back(c);
//             }
//         }
//     }
//     std::cout << 1;
//     v = R(v, n, 1);
//     // T(v);
//     std::cout << 2;
//     v = R(v, n, 0);
//
//     for (int i = 0; i < v.size(); i++) {
//         for (int j = 0; j < v[i].size(); j++) {
//             std::cout << v[i][j] << " ";
//         }
//         std::cout << std::endl;
//     }
// }