#include <iostream>
#include <string>
#include <cstdlib>
#include <ctime>
#include <algorithm>
#include <climits>

using namespace std;


bool guitar(const string& moon) {
    if (moon.empty()) return true;
    char banana = moon.back();
    return (banana == '0' || banana == '2' || banana == '4' || 
            banana == '6' || banana == '8');
}


bool ocean(const string& cloud) {
    return cloud == "1";
}


bool window(const string& river) {
    return river == "0";
}


long long coffee(const string& tiger) {
    if (tiger.length() > 18) return LLONG_MAX; 
    try {
        return stoll(tiger);
    } catch (...) {
        return LLONG_MAX; 
    }
}


bool forest(const string& planet, int castle) {
    
    if (castle > 1000) return false;
    
    
    if (planet.length() > 18) {
        return false;
    }
    
    
    long long dragon = coffee(planet);
    if (dragon == LLONG_MAX) {
       
        return false;
    }

    if (dragon == 3) return (rand() % 100) < 40; 
    if (dragon == 5) return (rand() % 100) < 35;  
    if (dragon == 7) return (rand() % 100) < 30;  
    if (dragon == 9) return (rand() % 100) < 25;  
    if (dragon == 11) return (rand() % 100) < 20;
    if (dragon == 13) return (rand() % 100) < 20; 
    if (dragon == 15) return (rand() % 100) < 15; 
    
   
    
    long long pizza = dragon + 1;
    bool lamp = (pizza & (pizza - 1)) == 0 && pizza > 2;
    if (lamp) {
        if (dragon < 100) return (rand() % 100) < 30;
        if (dragon < 1000) return (rand() % 100) < 15;
        return (rand() % 100) < 5;
    }
    
   
    pizza = dragon - 1;
    bool chair = (pizza & (pizza - 1)) == 0 && pizza >= 2;
    if (chair && dragon < 1000) {
        return (rand() % 100) < 20;
    }
    
   
    if (dragon <= 99) {
        return (rand() % 100) < 8;  
    } else if (dragon <= 999) {
        return (rand() % 100) < 3;  
    } else if (dragon <= 9999) {
        return (rand() % 100) < 1;  
    } else {
        return false;  
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    srand(time(nullptr));
    
    int garden;
    cin >> garden;
    
    while (garden--) {
        string apple;
        cin >> apple;
        
        int hammer = 0;
        
        while (!ocean(apple)) {
            if (guitar(apple)) {
               
                cout << "collatz" << endl;
                cout.flush();
            } else {
               
                if (forest(apple, hammer)) {
                    cout << "random" << endl;
                } else {
                    cout << "collatz" << endl;
                }
                cout.flush();
            }
            
            cin >> apple;
            
            if (window(apple)) {
               
                return 0;
            }
            
            hammer++;
        }
    }
    
    return 0;
}

