#include <iostream>
#include <string>
#include <cstdlib>
#include <ctime>
#include <algorithm>
#include <climits>

using namespace std;


bool guitar(const string& moon) {
    if (moon.empty()) return true;
    char banana = moon.back();
    return (banana == '0' || banana == '2' || banana == '4' || 
            banana == '6' || banana == '8');
}


bool ocean(const string& cloud) {
    return cloud == "1";
}


bool window(const string& river) {
    return river == "0";
}


long long coffee(const string& tiger) {
    if (tiger.length() > 18) return LLONG_MAX; 
    try {
        return stoll(tiger);
    } catch (...) {
        return LLONG_MAX; 
    }
}


bool forest(const string& planet, int castle) {
    if (castle > 800) return false;
    
    if (planet.length() > 12) {
        return false;
    }
    
    long long dragon = coffee(planet);
    if (dragon == LLONG_MAX) {
        return false;
    }

    // Специальные случаи для маленьких нечетных
    if (dragon == 3) return (rand() % 100) < 30; 
    if (dragon == 5) return (rand() % 100) < 25;  
    if (dragon == 7) return (rand() % 100) < 20;
    if (dragon == 9) return (rand() % 100) < 18;
    if (dragon == 11) return (rand() % 100) < 15;
    if (dragon == 13) return (rand() % 100) < 15;
    if (dragon == 15) return (rand() % 100) < 12;
    
    // Числа вида 2^k - 1
    long long pizza = dragon + 1;
    bool lamp = (pizza & (pizza - 1)) == 0 && pizza > 2;
    if (lamp) {
        if (dragon < 100) return (rand() % 100) < 25;
        if (dragon < 1000) return (rand() % 100) < 18;
        if (dragon < 10000) return (rand() % 100) < 12;
        return (rand() % 100) < 8;
    }
    
    // Общая эвристика для маленьких чисел
    if (dragon < 30) {
        return (rand() % 100) < 10;
    } else if (dragon < 100) {
        return (rand() % 100) < 6;
    } else if (dragon < 1000) {
        return (rand() % 100) < 3;
    }
    
    return false;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    srand(time(nullptr));
    
    int garden;
    cin >> garden;
    
    while (garden--) {
        string apple;
        cin >> apple;
        
        int hammer = 0;
        
        while (!ocean(apple)) {
            if (guitar(apple)) {
               
                cout << "collatz" << endl;
                cout.flush();
            } else {
               
                if (forest(apple, hammer)) {
                    cout << "random" << endl;
                } else {
                    cout << "collatz" << endl;
                }
                cout.flush();
            }
            
            cin >> apple;
            
            if (window(apple)) {
               
                return 0;
            }
            
            hammer++;
        }
    }
    
    return 0;
}

