#include <bits/stdc++.h>
using namespace std;


struct Cell {
    int q, r, val;
};

void T(int &q, int &r) {
    q = -q - r;
}

void R(int &q, int &r) {
    int nq = -r;
    int nr = q + r;
    q = nq; r = nr;
}

void L(int &q, int &r) {
    int nq = q + r;
    int nr = -q;
    q = nq; r = nr;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    int h = 2 * n - 1;

    vector<vector<int>> a(h);
    for (int i = 0; i < h; ++i) {
        int len = n + min(i, h - 1 - i);
        a[i].resize(len);
        for (int j = 0; j < len; ++j) cin >> a[i][j];
    }

    string ops;
    cin >> ops;

    vector<Cell> cells;
    for (int i = 0; i < h; ++i) {
        int len = a[i].size();
        int r = i - (n - 1);
        int q0 = -min(i, n - 1);
        for (int j = 0; j < len; ++j) {
            int q = q0 + j;
            cells.push_back({q, r, a[i][j]});
        }
    }


    for (char c : ops) {
        for (auto &cell : cells) {
            if (c == 'R') R(cell.q, cell.r);
            else if (c == 'L') L(cell.q, cell.r);
            else if (c == 'T') T(cell.q, cell.r);
        }
    }

    map<pair<int,int>, int> mp;
    for (auto &c : cells) mp[{c.q, c.r}] = c.val;

    for (int i = 0; i < h; ++i) {
        int r = i - (n - 1);
        int len = n + min(i, h - 1 - i);
        int q0 = -min(i, n - 1);

        for(int k = 0; k < abs(n - i - 1); k++){
            cout << ' ';
        }
        for (int j = 0; j < len; ++j) {
            int q = q0 + j;
            cout << mp[{q, r}];
            if (j + 1 < len) cout << ' ';
        }
        cout << '\n';
    }

    return 0;
}
