import sys

def get_q_offset(r, max_dist):
    return max(-max_dist, -max_dist - r)

def get_length(r, max_dist):
    q_min = get_q_offset(r, max_dist)
    q_max = min(max_dist, max_dist - r)
    return q_max - q_min + 1 if q_max >= q_min else 0

def pos_to_coord(row, col, n):
    max_dist = n - 1
    r = row - max_dist
    q_min = get_q_offset(r, max_dist)
    q = q_min + col
    return q, r

def coord_to_pos(q, r, n):
    max_dist = n - 1
    row = r + max_dist
    if row < 0 or row >= 2 * n - 1:
        sys.exit("error")
    q_min = get_q_offset(r, max_dist)
    q_max = min(max_dist, max_dist - r)
    if q < q_min or q > q_max:
        sys.exit("error")
    col = q - q_min
    return row, col

def rotate_cw(q, r):
    return -r, q + r

class Symmetry:
    def __init__(self, flipped, k):
        self.flipped = flipped
        self.k = k % 6

def mul(a, b):
    if not a.flipped:
        if not b.flipped:
            return Symmetry(False, a.k + b.k)
        else:
            return Symmetry(True, (b.k - a.k) % 6)
    else:
        if not b.flipped:
            return Symmetry(True, a.k + b.k)
        else:
            return Symmetry(False, (b.k - a.k) % 6)

def rotate_grid_cw(grid, n):
    max_dist = n - 1
    new_grid = [[0] * get_length(row - max_dist, max_dist) for row in range(2 * n - 1)]
    for row in range(2 * n - 1):
        for col in range(len(grid[row])):
            q, r = pos_to_coord(row, col, n)
            q_new, r_new = rotate_cw(q, r)
            new_row, new_col = coord_to_pos(q_new, r_new, n)
            new_grid[new_row][new_col] = grid[row][col]
    return new_grid

lines = sys.stdin.readlines()
n = int(lines[0].strip())
grid_lines = lines[1:1 + 2 * n - 1]
grid = []
for line in grid_lines:
    nums = [int(x) for x in line.split() if x]
    grid.append(nums)
ops = lines[1 + 2 * n - 1].strip()

current = Symmetry(False, 0)
for char in ops:
    if char == 'R':
        op = Symmetry(False, 1)
    elif char == 'L':
        op = Symmetry(False, 5)
    elif char == 'T':
        op = Symmetry(True, 0)
    current = mul(op, current)

temp_grid = [row[:] for row in grid]
for _ in range(current.k):
    temp_grid = rotate_grid_cw(temp_grid, n)
if current.flipped:
    for row in range(2 * n - 1):
        temp_grid[row] = temp_grid[row][::-1]

for row in temp_grid:
    print(' '.join(map(str, row)))