 #include <algorithm>
#include <cmath>
#include <iomanip>
#include <iostream>
#include <set>
#include <utility>
#include <vector>
using namespace std;

const long double PI = 3.14159265359;

int f(pair<int, int> a, pair<int, int> b, pair<int, int> c) {
  return (b.first - a.first) * (c.second - a.second) -
         (b.second - a.second) * (c.first - a.first);
}

vector<pair<int, int>> find(vector<pair<int, int>> &p) {
  int n = p.size();
  if (n <= 1)
    return p;

  sort(p.begin(), p.end());

  vector<pair<int, int>> h;

  for (int i = 0; i < n; i++) {
    while (h.size() >= 2 && f(h[h.size() - 2], h.back(), p[i]) <= 0) {
      h.pop_back();
    }
    h.push_back(p[i]);
  }

  int l = h.size();
  for (int i = n - 2; i >= 0; i--) {
    while (h.size() > l && f(h[h.size() - 2], h.back(), p[i]) <= 0) {
      h.pop_back();
    }
    h.push_back(p[i]);
  }

  if (h.size() > 1) {
    h.pop_back();
  }

  return h;
}

int main() {
  int n;
  cin >> n;
  vector<pair<int, int>> points(n);
  for (int i = 0; i < n; i++) {
    int a, b;
    cin >> a >> b;
    points[i] = {a, b};
  }

  vector<pair<int, int>> lin = find(points);
  // for (int i = 0; i < lin.size(); i++) {
  //   cout << lin[i].first << " " << lin[i].second << endl;
  // }
  int k = lin.size();
  double max_d = 0;
  int max_i = 0, max_j = 0;
  for (int i = 0; i < k; i++) {
    for (int j = i + 1; j < k; j++) {
      double dist = sqrt(pow(lin[i].first - lin[j].first, 2) +
                         pow(lin[i].second - lin[j].second, 2));
      if (dist > max_d) {
        max_d = dist;
        max_i = i;
        max_j = j;
      }
    }
  }

  pair<int, int> n_1 = lin[max_i];
  pair<int, int> n_2 = lin[max_j];
  
  pair<int, int> c = {n_2.first - n_1.first, n_2.second - n_1.second};

  cout << c.first << " " << c.second << " "
       << -(c.first * n_1.first + c.second * n_1.second);
  cout << endl;
  cout << c.first << " " << c.second << " "
       << -(c.first * n_2.first + c.second * n_2.second);
}
