MOD = 10**9 + 7

t = int(input())

tests = []
for _ in range(t):
    p, m = map(int, input().split())
    tests.append((p, m))

max_p = max(p for p, _ in tests)
max_n = 2 * max_p + 1

fact = [1] * (max_n + 2)
for i in range(1, max_n + 2):
    fact[i] = fact[i - 1] * i % MOD

inv_fact = [1] * (max_n + 2)
inv_fact[max_n + 1] = pow(fact[max_n + 1], MOD - 2, MOD)
for i in range(max_n, -1, -1):
    inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD

pow4 = [1] * (max_p + 1)
for i in range(1, max_p + 1):
    pow4[i] = pow4[i - 1] * 4 % MOD

results = []
for p, m in tests:
    n = 2 * p + m
    numerator = (n + 1) * pow4[p] % MOD
    numerator = numerator * fact[p] % MOD
    numerator = numerator * fact[p] % MOD
    denominator = fact[2 * p + 1]
    ans = numerator * inv_fact[2 * p + 1] % MOD
    results.append(str(ans))

print("\n".join(results))