#include <bits/stdc++.h>
using namespace std;

const int mod = 1000000007;
const int maxN = 2000001;
const int maxP = 1000000;

long long f[maxN + 1];
long long invF[maxN + 1];
long long pow4[maxP + 1];

long long pm(long long b, long long e, long long m)
{
    long long res = 1;
    while (e)
    {
        if (e & 1) res = res * b % m;
        b = b * b % m;
        e >>= 1;
    }
    return res;
}

void precomp()
{
    f[0] = 1;
    for (int i = 1; i <= maxN; i++)
    {
        f[i] = f[i - 1] * i % mod;
    }
    invF[maxN] = pm(f[maxN], mod - 2, mod);
    for (int i = maxN - 1; i >= 0; i--)
    {
        invF[i] = invF[i + 1] * (i + 1) % mod;
    }
    pow4[0] = 1;
    for (int i = 1; i <= maxP; i++)
    {
        pow4[i] = pow4[i - 1] * 4 % mod;
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    precomp();
    int t;
    cin >> t;
    while (t--)
    {
        int p, m;
        cin >> p >> m;
        long long n = 2 * p + m;
        long long nume = (n + 1) * pow4[p] % mod;
        nume = nume * f[p] % mod;
        nume = nume * f[p] % mod;
        long long o = nume * invF[2 * p + 1] % mod;
        cout << o << '\n';
    }
    return 0;
}
