#include <bits/stdc++.h>
#include <numeric>

using namespace std;

struct mint {
private:
    int val;
    const static int mod = 1e9 + 7;

public:
    mint() : val(0) {}

    mint(int x) : val((x >= 0 ? x : mod + x)) {}

    mint operator+(const mint oth) const {
        int sum = val + oth.val;
        if (sum >= mod) {
            sum -= mod;
        }
        return sum;
    }

    void operator+=(const mint oth) {
        *this = *this + oth;
    }

    mint operator-() const {
        return val == 0 ? 0 : mod - val;
    }

    mint operator-(const mint oth) const {
        return *this + (-oth);
    }

    void operator-=(const mint oth) {
        *this = *this - oth;
    }

    mint operator*(const mint oth) const {
        return (1ll * val * oth.val) % mod;
    }

    void operator*=(const mint oth) {
        *this = *this * oth;
    }

    static mint pow(mint num, int pw) {
        mint res(1);
        while (pw > 0) {
            if (pw & 1) {
                res *= num;
            }
            num *= num;
            pw >>= 1;
        }
        return res;
    }

    mint operator/(const mint oth) const {
        return *this * pow(oth, mod - 2);
    }

    void operator/=(const mint oth) {
        *this = *this / oth;
    }

    friend istream &operator>>(istream &in, mint &oth) {
        int x;
        in >> x;
        oth = mint(x % mod);
        return in;
    }

    friend ostream &operator<<(ostream &out, mint &oth) {
        out << oth.val;
        return out;
    }
};

const size_t MAXN = 5e6;
mint fact[MAXN], infact[MAXN];

mint C(int n, int k) {
    return fact[n] * infact[k] * infact[n - k];
}

mint get_f(int n) {
    mint pw(1);
    pw = pw.pow(mint(4), n);
    mint div = C(2 * n, n);
    return pw / div;
}

void solve() {
    int n, m;
    cin >> n >> m;
    if (n == 0) {
        cout << m;
        return;
    }
    mint fn = get_f(n);
    mint fn1 = get_f(n + 1);
    mint step = fn1 - fn;
    mint res = fn + step * mint(m);
    cout << res;
}

void Fast() {
    cin.tie(nullptr);
    cout.tie(nullptr);
    ios_base::sync_with_stdio(false);
}

signed main() {
    Fast();
    int t;
    cin >> t;
    fact[0] = mint(1);
    for (int i = 1; i < MAXN; i++) {
        fact[i] = fact[i - 1] * mint(i);
    }
    infact[MAXN - 1] = mint(1) / fact[MAXN - 1];
    for (int i = MAXN - 2; i >= 0; i--) {
        infact[i] = infact[i + 1] * mint(i + 1);
    }
    while (t--) {
        solve();
        cout << endl;
    }
}
