#include <iostream>
#include <vector>

using namespace std;

long long int mod = 1e9 + 7;
const int MAX_P = 1e6;

vector<long long int> e_p0(MAX_P + 1);

long long int power(long long int b, long long int exp) {
    long long int res = 1;
    b %= mod;
    while (exp > 0) {
        if (exp % 2 == 1) {
            res = (res * b) % mod;
        }
        b = (b * b) % mod;
        exp /= 2;
    }
    return res;
}

long long int rev(long long int n) {
    return power(n, mod - 2);
}

void precompute() {
    e_p0[1] = 2;

    for (long long int p = 2; p <= MAX_P; ++p) {
        long long int num = 2 * p;
        long long int den = 2 * p - 1;

        long long int term = (num * rev(den)) % mod;

        e_p0[p] = (e_p0[p-1] * term) % mod;
    }
}

void solve() {
    long long int p, m;
    cin >> p >> m;

    long long int a = e_p0[p];

    long long int df = 2 * p + 1;
    long long int nf = 2 * p + m + 1;

    long long int res = (a * nf) % mod;
    res = (res * rev(df)) % mod;

    if (res < 0) {
        res += mod;
    }

    cout << res << "\n";
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    precompute();

    int t;
    cin >> t;
    while (t--) {
        solve();
    }

    return 0;
}