def solve():
    # Read the launch indicator
    launch = int(input())

    if launch == 0:
        # First launch: determine which player should guess
        n = int(input())
        cards = list(map(int, input().split()))

        # Back to the working formula: (sum + 1) % n + 1
        total_sum = sum(cards)
        player_to_guess = (total_sum + 1) % n + 1
        print(player_to_guess)

    else:
        # Second launch: the chosen player makes a guess
        player_number = launch
        n = int(input())
        visible_cards = list(map(int, input().split()))

        visible_sum = sum(visible_cards)
        total_players = n + 1

        # Use the inverse of the encoding:
        # (visible_sum + missing_card + 1) % total_players + 1 = player_number
        # So: (visible_sum + missing_card + 1) % total_players = player_number - 1
        # missing_card = (player_number - 1 - visible_sum - 1) % total_players
        # missing_card = (player_number - 2 - visible_sum) % total_players

        missing_card = (player_number - 2 - visible_sum) % total_players
        print(missing_card)

if __name__ == "__main__":
    solve()