def solve():
    """
    Финальное решение задачи "Кто я?"
    Используем стандартную стратегию с суммой по модулю
    """
    # Читаем индикатор запуска
    launch = int(input())
    
    if launch == 0:
        # Первый запуск: определяем, какой игрок должен угадать
        n = int(input())  # общее количество игроков
        cards = list(map(int, input().split()))
        
        # Используем сумму по модулю n для выбора игрока
        total_sum = sum(cards)
        player_to_guess = total_sum % n + 1
        print(player_to_guess)
        
    else:
        # Второй запуск: выбранный игрок делает предположение
        player_number = launch
        n = int(input())  # количество видимых карт
        visible_cards = list(map(int, input().split()))
        
        # Вычисляем сумму видимых карт
        visible_sum = sum(visible_cards)
        total_players = n + 1  # общее количество игроков
        
        # Обратная формула:
        # total_sum % total_players + 1 = player_number
        # total_sum % total_players = player_number - 1
        # (visible_sum + missing_card) % total_players = player_number - 1
        # missing_card = (player_number - 1 - visible_sum) % total_players
        
        missing_card = (player_number - 1 - visible_sum) % total_players
        
        # Убеждаемся, что результат в правильном диапазоне [1, total_players]
        if missing_card == 0:
            missing_card = total_players
            
        print(missing_card)

if __name__ == "__main__":
    solve()
