def solve():
    # Read the launch indicator
    launch = int(input())

    if launch == 0:
        # First launch: determine which player should guess
        n = int(input())
        cards = list(map(int, input().split()))

        # Correct strategy: (sum + 1) % n + 1
        total_sum = sum(cards)
        player_to_guess = (total_sum + 1) % n + 1
        print(player_to_guess)

    else:
        # Second launch: the chosen player makes a guess
        player_number = launch
        n = int(input())  # This is the number of visible cards (n-1 from total)
        visible_cards = list(map(int, input().split()))

        visible_sum = sum(visible_cards)

        # The total number of players is n+1 (since we see n cards, and 1 is missing)
        total_players = n + 1

        # We need: (visible_sum + missing_card + 1) % total_players + 1 = player_number
        # So: (visible_sum + missing_card + 1) % total_players = player_number - 1
        # visible_sum + missing_card + 1 ≡ player_number - 1 (mod total_players)
        # missing_card ≡ player_number - 1 - visible_sum - 1 (mod total_players)
        # missing_card ≡ player_number - 2 - visible_sum (mod total_players)

        missing_card = (player_number - 2 - visible_sum) % total_players
        print(missing_card)

if __name__ == "__main__":
    solve()